/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.ExhaustedAction;

@BuiltBy(value=ConnectionPoolConfigurationBuilder.class)
public class ConnectionPoolConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<ExhaustedAction> EXHAUSTED_ACTION = AttributeDefinition.builder((String)"exhaustedAction", (Object)((Object)ExhaustedAction.WAIT), ExhaustedAction.class).immutable().build();
    static final AttributeDefinition<Integer> MAX_ACTIVE = AttributeDefinition.builder((String)"maxActive", (Object)-1).immutable().build();
    static final AttributeDefinition<Integer> MAX_WAIT = AttributeDefinition.builder((String)"maxWait", (Object)-1).immutable().build();
    static final AttributeDefinition<Integer> MIN_IDLE = AttributeDefinition.builder((String)"minIdle", (Object)-1).immutable().build();
    static final AttributeDefinition<Long> MIN_EVICTABLE_IDLE_TIME = AttributeDefinition.builder((String)"minEvictableIdleTime", (Object)1800000L).immutable().build();
    static final AttributeDefinition<Integer> MAX_PENDING_REQUESTS = AttributeDefinition.builder((String)"maxPendingRequests", (Object)5).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.CONNECTION_POOL.getLocalName());
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ConnectionPoolConfiguration.class, new AttributeDefinition[]{EXHAUSTED_ACTION, MAX_ACTIVE, MAX_WAIT, MIN_IDLE, MIN_EVICTABLE_IDLE_TIME, MAX_PENDING_REQUESTS});
    }

    ConnectionPoolConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ExhaustedAction exhaustedAction() {
        return (ExhaustedAction)((Object)this.attributes.attribute(EXHAUSTED_ACTION).get());
    }

    public int maxActive() {
        return (Integer)this.attributes.attribute(MAX_ACTIVE).get();
    }

    public int maxWait() {
        return (Integer)this.attributes.attribute(MAX_WAIT).get();
    }

    @Deprecated
    public int maxIdle() {
        return -1;
    }

    public int minIdle() {
        return (Integer)this.attributes.attribute(MIN_IDLE).get();
    }

    public int maxPendingRequests() {
        return (Integer)this.attributes.attribute(MAX_PENDING_REQUESTS).get();
    }

    public long minEvictableIdleTime() {
        return (Long)this.attributes.attribute(MIN_EVICTABLE_IDLE_TIME).get();
    }

    public String toString() {
        return "ConnectionPoolConfiguration [exhaustedAction=" + (Object)((Object)this.exhaustedAction()) + ", maxActive=" + this.maxActive() + ", maxPendingRequests=" + this.maxPendingRequests() + ", maxWait=" + this.maxWait() + ", minIdle=" + this.minIdle() + ", minEvictableIdleTime=" + this.minEvictableIdleTime() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPoolConfiguration that = (ConnectionPoolConfiguration)o;
        if (this.maxActive() != that.maxActive()) {
            return false;
        }
        if (this.maxWait() != that.maxWait()) {
            return false;
        }
        if (this.minIdle() != that.minIdle()) {
            return false;
        }
        if (this.minEvictableIdleTime() != that.minEvictableIdleTime()) {
            return false;
        }
        if (this.maxPendingRequests() != that.maxPendingRequests()) {
            return false;
        }
        return this.exhaustedAction() == that.exhaustedAction();
    }

    public int hashCode() {
        int result = this.exhaustedAction() != null ? this.exhaustedAction().hashCode() : 0;
        result = 31 * result + this.maxActive();
        result = 31 * result + this.maxWait();
        result = 31 * result + this.minIdle();
        result = 31 * result + (int)(this.minEvictableIdleTime() ^ this.minEvictableIdleTime() >>> 32);
        result = 31 * result + this.maxPendingRequests();
        return result;
    }
}

