/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso.elytron;

import java.io.IOException;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.web.undertow.sso.elytron.ElytronAuthentication;

public class ElytronAuthenticationMarshaller
implements ProtoStreamMarshaller<ElytronAuthentication> {
    private static final int MECHANISM_INDEX = 1;
    private static final int NAME_INDEX = 2;
    private static final String DEFAULT_MECHANISM = "FORM";

    public ElytronAuthentication readFrom(ProtoStreamReader reader) throws IOException {
        String mechanism = DEFAULT_MECHANISM;
        String name = null;
        boolean reading = true;
        block4: while (reading) {
            int tag = reader.readTag();
            switch (WireFormat.getTagFieldNumber((int)tag)) {
                case 1: {
                    mechanism = reader.readString();
                    continue block4;
                }
                case 2: {
                    name = reader.readString();
                    continue block4;
                }
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return new ElytronAuthentication(mechanism, name);
    }

    public void writeTo(ProtoStreamWriter writer, ElytronAuthentication auth) throws IOException {
        String name;
        String mechanism = auth.getMechanism();
        if (!mechanism.equals(DEFAULT_MECHANISM)) {
            writer.writeString(1, mechanism);
        }
        if ((name = auth.getName()) != null) {
            writer.writeString(2, name);
        }
    }

    public Class<? extends ElytronAuthentication> getJavaClass() {
        return ElytronAuthentication.class;
    }
}

