/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.outbound;

import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.mw.wst.common.SOAPUtil;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.Iterator;
import org.jboss.jbossts.txbridge.outbound.JaxWSTxOutboundBridgeHandler;

public abstract class AbstractJTAOverWSATHandler<C extends MessageContext>
implements Handler<C> {
    private final JaxWSTxOutboundBridgeHandler delegateHandler = new JaxWSTxOutboundBridgeHandler();

    public boolean handleMessage(C context) {
        if (this.isContextPropagationEnabled(context) && this.isJTATransactionOnThread() && !this.isWSATContext((MessageContext)context)) {
            return this.delegateHandler.handleMessage((MessageContext)context);
        }
        return true;
    }

    public boolean handleFault(C context) {
        if (this.isContextPropagationEnabled(context) && this.isJTATransactionOnThread() && !this.isWSATContext((MessageContext)context)) {
            return this.delegateHandler.handleFault((MessageContext)context);
        }
        return true;
    }

    public void close(MessageContext context) {
        this.delegateHandler.close(context);
    }

    private boolean isJTATransactionOnThread() {
        boolean isJTATransaction = false;
        try {
            Transaction transaction = TransactionManager.transactionManager().getTransaction();
            isJTATransaction = transaction != null;
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return isJTATransaction;
    }

    private boolean isWSATContext(MessageContext context) {
        boolean isWSATContext = false;
        if (context instanceof SOAPMessageContext) {
            SOAPMessageContext soapMessageContext = (SOAPMessageContext)context;
            SOAPHeaderElement soapHeaderElement = this.getHeaderElement(soapMessageContext, "http://schemas.arjuna.com/ws/2005/10/wsarj", "InstanceIdentifier");
            isWSATContext = soapHeaderElement != null;
        }
        return isWSATContext;
    }

    private SOAPHeaderElement getHeaderElement(SOAPMessageContext soapMessageContext, String uri, String name) {
        SOAPHeaderElement soapHeaderElement = null;
        try {
            SOAPMessage soapMessage = soapMessageContext.getMessage();
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            if (soapHeader != null) {
                soapHeaderElement = this.getHeaderElement(soapHeader, uri, name);
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return soapHeaderElement;
    }

    private SOAPHeaderElement getHeaderElement(SOAPHeader soapHeader, String uri, String name) throws SOAPException {
        Iterator iterator = SOAPUtil.getChildElements((SOAPElement)soapHeader);
        while (iterator.hasNext()) {
            SOAPHeaderElement current = (SOAPHeaderElement)iterator.next();
            Name currentName = current.getElementName();
            if (currentName == null || !this.match(name, currentName.getLocalName()) || !this.match(uri, currentName.getURI())) continue;
            return current;
        }
        return null;
    }

    private boolean match(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.equals(rhs);
    }

    protected abstract boolean isContextPropagationEnabled(C var1);
}

