/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe;

import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.resteasy.jose.Base64Url;
import org.jboss.resteasy.jose.i18n.Messages;
import org.jboss.resteasy.jose.jwe.Algorithm;
import org.jboss.resteasy.jose.jwe.CompressionAlgorithm;
import org.jboss.resteasy.jose.jwe.EncryptionMethod;
import org.jboss.resteasy.jose.jwe.crypto.DirectEncrypter;
import org.jboss.resteasy.jose.jwe.crypto.RSAEncrypter;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class JWEBuilder {
    String type;
    String contentType;
    byte[] contentBytes;
    Providers providers;
    CompressionAlgorithm compressionAlgorithm;
    EncryptionMethod encryptionMethod = EncryptionMethod.A256CBC_HS512;

    public JWEBuilder() {
        this((Providers)ResteasyProviderFactory.getInstance());
    }

    public JWEBuilder(Providers providers) {
        this.providers = providers;
    }

    public JWEBuilder type(String type) {
        this.type = type;
        return this;
    }

    public JWEBuilder contentType(String type) {
        this.contentType = type;
        return this;
    }

    public JWEBuilder contentType(MediaType type) {
        this.contentType = type.toString();
        return this;
    }

    public EncryptionBuilder contentBytes(byte[] bytes) {
        this.contentBytes = bytes;
        return new EncryptionBuilder();
    }

    public EncryptionBuilder content(Object content) {
        this.contentBytes = this.marshalContent(content, MediaType.valueOf((String)this.contentType));
        return new EncryptionBuilder();
    }

    public EncryptionBuilder content(Object content, MediaType marshalTo) {
        this.contentBytes = this.marshalContent(content, marshalTo);
        return new EncryptionBuilder();
    }

    protected String encodeHeader(Algorithm alg) {
        StringBuilder builder = new StringBuilder("{");
        builder.append("\"alg\":\"").append(alg.toString()).append("\"");
        builder.append(",\"enc\":\"").append(this.encryptionMethod.toString()).append("\"");
        if (this.compressionAlgorithm != null) {
            builder.append(",\"zip\":\"").append(this.compressionAlgorithm.toString()).append("\"");
        }
        if (this.type != null) {
            builder.append(",\"typ\" : \"").append(this.type).append("\"");
        }
        if (this.contentType != null) {
            builder.append(",\"cty\":\"").append(this.contentType).append("\"");
        }
        builder.append("}");
        String json = builder.toString();
        return Base64Url.encode(json.getBytes(StandardCharsets.UTF_8));
    }

    protected byte[] marshalContent(Object content, MediaType marshalTo) {
        MessageBodyWriter writer;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Class type = content.getClass();
        Type genericType = null;
        Object obj = content;
        if (content instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)content;
            obj = ge.getEntity();
            type = ge.getRawType();
            genericType = ge.getType();
        }
        if (genericType == null) {
            genericType = type;
        }
        if ((writer = this.providers.getMessageBodyWriter(type, genericType, null, marshalTo)) == null) {
            throw new IllegalStateException(Messages.MESSAGES.unableToFindMessageBodyWriter());
        }
        try {
            writer.writeTo(obj, type, genericType, null, marshalTo, (MultivaluedMap)new MultivaluedHashMap(), (OutputStream)baos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public class EncryptionBuilder {
        public EncryptionBuilder compressed() {
            JWEBuilder.this.compressionAlgorithm = CompressionAlgorithm.DEF;
            return this;
        }

        public EncryptionBuilder A128CBC_HS256() {
            JWEBuilder.this.encryptionMethod = EncryptionMethod.A128CBC_HS256;
            return this;
        }

        public EncryptionBuilder A256CBC_HS512() {
            JWEBuilder.this.encryptionMethod = EncryptionMethod.A256CBC_HS512;
            return this;
        }

        public EncryptionBuilder A128GCM() {
            JWEBuilder.this.encryptionMethod = EncryptionMethod.A128GCM;
            return this;
        }

        public EncryptionBuilder A256GCM() {
            JWEBuilder.this.encryptionMethod = EncryptionMethod.A256GCM;
            return this;
        }

        public String RSA1_5(RSAPublicKey publicKey) {
            String header = JWEBuilder.this.encodeHeader(Algorithm.RSA1_5);
            return RSAEncrypter.encrypt(Algorithm.RSA1_5, JWEBuilder.this.encryptionMethod, JWEBuilder.this.compressionAlgorithm, publicKey, header, JWEBuilder.this.contentBytes);
        }

        public String RSA_OAEP(RSAPublicKey publicKey) {
            String header = JWEBuilder.this.encodeHeader(Algorithm.RSA_OAEP);
            return RSAEncrypter.encrypt(Algorithm.RSA_OAEP, JWEBuilder.this.encryptionMethod, JWEBuilder.this.compressionAlgorithm, publicKey, header, JWEBuilder.this.contentBytes);
        }

        public String dir(String secret) {
            MessageDigest digest = JWEBuilder.this.encryptionMethod.createSecretDigester();
            byte[] hash = digest.digest(secret.getBytes(StandardCharsets.UTF_8));
            return this.dir(hash);
        }

        public String dir(byte[] secret) {
            SecretKeySpec key = new SecretKeySpec(secret, "AES");
            return this.dir(key);
        }

        public String dir(SecretKey key) {
            if (!key.getAlgorithm().equals("AES")) {
                throw new IllegalArgumentException(Messages.MESSAGES.algorithmOfSharedSymmetricKey());
            }
            byte[] keyBytes = key.getEncoded();
            if (keyBytes.length != 16 && keyBytes.length != 32 && keyBytes.length != 64) {
                throw new IllegalArgumentException(Messages.MESSAGES.lengthOfSharedSymmetricKey());
            }
            String header = JWEBuilder.this.encodeHeader(Algorithm.dir);
            return DirectEncrypter.encrypt(JWEBuilder.this.encryptionMethod, JWEBuilder.this.compressionAlgorithm, header, key, JWEBuilder.this.contentBytes);
        }
    }
}

