/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.webserviceref;

import jakarta.jws.HandlerChain;
import jakarta.xml.ws.RespectBinding;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceRef;
import jakarta.xml.ws.WebServiceRefs;
import jakarta.xml.ws.soap.MTOM;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.metadata.javaee.jboss.JBossPortComponentRef;
import org.jboss.metadata.javaee.jboss.JBossServiceReferenceMetaData;
import org.jboss.metadata.javaee.jboss.StubPropertyMetaData;
import org.jboss.metadata.javaee.spec.Addressing;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.PortComponentRef;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlersMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.AddressingMetadata;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.MTOMMetadata;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.RespectBindingMetadata;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaDataBuilder;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaDataBuilder;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

final class WSRefUtils {
    private WSRefUtils() {
    }

    static UnifiedServiceRefMetaData translate(ServiceReferenceMetaData serviceRefMD) {
        ServiceReferenceHandlerChainsMetaData handlerChainsMD;
        ServiceReferenceHandlersMetaData handlersMD;
        UnifiedServiceRefMetaDataBuilder builder = new UnifiedServiceRefMetaDataBuilder();
        builder.setServiceRefName(serviceRefMD.getName());
        builder.setServiceRefType(serviceRefMD.getServiceRefType());
        builder.setServiceInterface(serviceRefMD.getServiceInterface());
        builder.setWsdlFile(serviceRefMD.getWsdlFile());
        builder.setMappingFile(serviceRefMD.getJaxrpcMappingFile());
        builder.setServiceQName(serviceRefMD.getServiceQname());
        List portComponentsMD = serviceRefMD.getPortComponentRef();
        if (portComponentsMD != null) {
            for (PortComponentRef portComponentMD : portComponentsMD) {
                UnifiedPortComponentRefMetaData portComponentUMDM = WSRefUtils.getUnifiedPortComponentRefMetaData(portComponentMD);
                if (portComponentUMDM.getServiceEndpointInterface() != null || portComponentUMDM.getPortQName() != null) {
                    builder.addPortComponentRef(portComponentUMDM);
                    continue;
                }
                WSLogger.ROOT_LOGGER.ignoringPortComponentRef(portComponentUMDM);
            }
        }
        if ((handlersMD = serviceRefMD.getHandlers()) != null) {
            for (ServiceReferenceHandlerMetaData handlerMD : handlersMD) {
                UnifiedHandlerMetaData handlerUMDM = WSRefUtils.getUnifiedHandlerMetaData(handlerMD);
                builder.addHandler(handlerUMDM);
            }
        }
        if ((handlerChainsMD = serviceRefMD.getHandlerChains()) != null) {
            UnifiedHandlerChainsMetaData handlerChainsUMDM = WSRefUtils.getUnifiedHandlerChainsMetaData(handlerChainsMD);
            builder.setHandlerChains(handlerChainsUMDM);
        }
        if (serviceRefMD instanceof JBossServiceReferenceMetaData) {
            JBossServiceReferenceMetaData jbossServiceRefMD = (JBossServiceReferenceMetaData)serviceRefMD;
            builder.setServiceImplClass(jbossServiceRefMD.getServiceClass());
            builder.setConfigName(jbossServiceRefMD.getConfigName());
            builder.setConfigFile(jbossServiceRefMD.getConfigFile());
            builder.setWsdlOverride(jbossServiceRefMD.getWsdlOverride());
            builder.setHandlerChain(jbossServiceRefMD.getHandlerChain());
        }
        return builder.build();
    }

    private static UnifiedPortComponentRefMetaData getUnifiedPortComponentRefMetaData(PortComponentRef portComponentMD) {
        UnifiedPortComponentRefMetaDataBuilder builder = new UnifiedPortComponentRefMetaDataBuilder();
        builder.setServiceEndpointInterface(portComponentMD.getServiceEndpointInterface());
        builder.setMtomEnabled(portComponentMD.isEnableMtom());
        builder.setMtomThreshold(portComponentMD.getMtomThreshold());
        Addressing addressingMD = portComponentMD.getAddressing();
        if (addressingMD != null) {
            builder.setAddressingAnnotationSpecified(true);
            builder.setAddressingEnabled(addressingMD.isEnabled());
            builder.setAddressingRequired(addressingMD.isRequired());
            builder.setAddressingResponses(addressingMD.getResponses());
        }
        if (portComponentMD.getRespectBinding() != null) {
            builder.setRespectBindingAnnotationSpecified(true);
            builder.setRespectBindingEnabled(true);
        }
        builder.setPortComponentLink(portComponentMD.getPortComponentLink());
        if (portComponentMD instanceof JBossPortComponentRef) {
            JBossPortComponentRef jbossPortComponentMD = (JBossPortComponentRef)portComponentMD;
            builder.setPortQName(jbossPortComponentMD.getPortQname());
            builder.setConfigName(jbossPortComponentMD.getConfigName());
            builder.setConfigFile(jbossPortComponentMD.getConfigFile());
            List stubPropertiesMD = jbossPortComponentMD.getStubProperties();
            if (stubPropertiesMD != null) {
                for (StubPropertyMetaData stubPropertyMD : stubPropertiesMD) {
                    builder.addStubProperty(new UnifiedStubPropertyMetaData(stubPropertyMD.getPropName(), stubPropertyMD.getPropValue()));
                }
            }
        }
        return builder.build();
    }

    private static UnifiedHandlerMetaData getUnifiedHandlerMetaData(ServiceReferenceHandlerMetaData srhmd) {
        List soapHeaders;
        LinkedList<UnifiedInitParamMetaData> unifiedInitParamMDs = new LinkedList<UnifiedInitParamMetaData>();
        List initParams = srhmd.getInitParam();
        if (initParams != null) {
            for (ParamValueMetaData initParam : initParams) {
                unifiedInitParamMDs.add(new UnifiedInitParamMetaData(initParam.getParamName(), initParam.getParamValue()));
            }
        }
        HashSet soapHeaderList = (soapHeaders = srhmd.getSoapHeader()) != null ? new HashSet(soapHeaders) : null;
        List soapRoles = srhmd.getSoapRole();
        HashSet soapRolesList = soapRoles != null ? new HashSet(soapRoles) : null;
        List portNames = srhmd.getPortName();
        HashSet portNameList = portNames != null ? new HashSet(portNames) : null;
        return new UnifiedHandlerMetaData(srhmd.getHandlerClass(), srhmd.getHandlerName(), unifiedInitParamMDs, soapHeaderList, soapRolesList, portNameList);
    }

    private static UnifiedHandlerChainsMetaData getUnifiedHandlerChainsMetaData(ServiceReferenceHandlerChainsMetaData handlerChainsMD) {
        LinkedList<UnifiedHandlerChainMetaData> uhcmds = new LinkedList<UnifiedHandlerChainMetaData>();
        for (ServiceReferenceHandlerChainMetaData handlerChainMD : handlerChainsMD.getHandlers()) {
            LinkedList<UnifiedHandlerMetaData> uhmds = new LinkedList<UnifiedHandlerMetaData>();
            for (ServiceReferenceHandlerMetaData handlerMD : handlerChainMD.getHandler()) {
                UnifiedHandlerMetaData handlerUMDM = WSRefUtils.getUnifiedHandlerMetaData(handlerMD);
                uhmds.add(handlerUMDM);
            }
            uhcmds.add(new UnifiedHandlerChainMetaData(handlerChainMD.getServiceNamePattern(), handlerChainMD.getPortNamePattern(), handlerChainMD.getProtocolBindings(), uhmds, false, null));
        }
        return new UnifiedHandlerChainsMetaData(uhcmds);
    }

    static void processAnnotatedElement(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        WSRefUtils.processAddressingAnnotation(anElement, serviceRefUMDM);
        WSRefUtils.processMTOMAnnotation(anElement, serviceRefUMDM);
        WSRefUtils.processRespectBindingAnnotation(anElement, serviceRefUMDM);
        WSRefUtils.processHandlerChainAnnotation(anElement, serviceRefUMDM);
        WSRefUtils.processServiceRefType(anElement, serviceRefUMDM);
    }

    private static void processAddressingAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        jakarta.xml.ws.soap.Addressing addressingAnnotation = WSRefUtils.getAnnotation(anElement, jakarta.xml.ws.soap.Addressing.class);
        if (addressingAnnotation != null) {
            serviceRefUMDM.setAddressingMedadata(new AddressingMetadata(true, addressingAnnotation.enabled(), addressingAnnotation.required(), addressingAnnotation.responses().toString()));
        }
    }

    private static void processMTOMAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        MTOM mtomAnnotation = WSRefUtils.getAnnotation(anElement, MTOM.class);
        if (mtomAnnotation != null) {
            serviceRefUMDM.setMTOMMetadata(new MTOMMetadata(true, mtomAnnotation.enabled(), mtomAnnotation.threshold()));
        }
    }

    private static void processRespectBindingAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        RespectBinding respectBindingAnnotation = WSRefUtils.getAnnotation(anElement, RespectBinding.class);
        if (respectBindingAnnotation != null) {
            serviceRefUMDM.setRespectBindingMetadata(new RespectBindingMetadata(true, respectBindingAnnotation.enabled()));
        }
    }

    private static void processServiceRefType(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        if (anElement instanceof Field) {
            Class<?> targetClass = ((Field)anElement).getType();
            serviceRefUMDM.setServiceRefType(targetClass.getName());
            if (Service.class.isAssignableFrom(targetClass)) {
                serviceRefUMDM.setServiceInterface(targetClass.getName());
            }
        } else if (anElement instanceof Method) {
            Class<?> targetClass = ((Method)anElement).getParameterTypes()[0];
            serviceRefUMDM.setServiceRefType(targetClass.getName());
            if (Service.class.isAssignableFrom(targetClass)) {
                serviceRefUMDM.setServiceInterface(targetClass.getName());
            }
        } else {
            WebServiceRef serviceRefAnnotation = WSRefUtils.getWebServiceRefAnnotation(anElement, serviceRefUMDM);
            Class targetClass = null;
            if (serviceRefAnnotation != null && serviceRefAnnotation.type() != Object.class) {
                targetClass = serviceRefAnnotation.type();
                serviceRefUMDM.setServiceRefType(targetClass.getName());
                if (Service.class.isAssignableFrom(targetClass)) {
                    serviceRefUMDM.setServiceInterface(targetClass.getName());
                }
            }
        }
    }

    private static void processHandlerChainAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        HandlerChain handlerChainAnnotation = WSRefUtils.getAnnotation(anElement, HandlerChain.class);
        if (handlerChainAnnotation != null) {
            String handlerChain = null;
            if (handlerChainAnnotation.file().length() > 0) {
                handlerChain = handlerChainAnnotation.file();
            }
            if (handlerChain != null) {
                try {
                    new URL(handlerChain);
                }
                catch (MalformedURLException ignored) {
                    Class<?> declaringClass = WSRefUtils.getDeclaringClass(anElement);
                    handlerChain = declaringClass.getPackage().getName().replace('.', '/') + "/" + handlerChain;
                }
                serviceRefUMDM.setHandlerChain(handlerChain);
            }
        }
    }

    private static <T extends Annotation> T getAnnotation(AnnotatedElement anElement, Class<T> annotationClass) {
        return anElement != null ? (T)anElement.getAnnotation(annotationClass) : null;
    }

    private static Class<?> getDeclaringClass(AnnotatedElement annotatedElement) {
        Class declaringClass = null;
        if (annotatedElement instanceof Field) {
            declaringClass = ((Field)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Method) {
            declaringClass = ((Method)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Class) {
            declaringClass = (Class)annotatedElement;
        }
        return declaringClass;
    }

    private static WebServiceRef getWebServiceRefAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        WebServiceRef webServiceRefAnnotation = WSRefUtils.getAnnotation(anElement, WebServiceRef.class);
        WebServiceRefs webServiceRefsAnnotation = WSRefUtils.getAnnotation(anElement, WebServiceRefs.class);
        if (webServiceRefAnnotation == null && webServiceRefsAnnotation == null) {
            return null;
        }
        ArrayList<WebServiceRef> wsrefList = new ArrayList<WebServiceRef>();
        if (webServiceRefAnnotation != null) {
            wsrefList.add(webServiceRefAnnotation);
        }
        if (webServiceRefsAnnotation != null) {
            for (WebServiceRef webServiceRefAnn : webServiceRefsAnnotation.value()) {
                wsrefList.add(webServiceRefAnn);
            }
        }
        WebServiceRef returnValue = null;
        if (wsrefList.size() == 1) {
            returnValue = (WebServiceRef)wsrefList.get(0);
        } else {
            for (WebServiceRef webServiceRefAnn : wsrefList) {
                if (!serviceRefUMDM.getServiceRefName().endsWith(webServiceRefAnn.name())) continue;
                returnValue = webServiceRefAnn;
                break;
            }
        }
        return returnValue;
    }
}

