/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.marshall.AbstractExternalizer;

public abstract class InstanceReusingAdvancedExternalizer<T>
extends AbstractExternalizer<T> {
    private static ThreadLocal<ReusableData> cachedWriteObjects = new ThreadLocal();
    private static ThreadLocal<List<Object>> cachedReadObjects = new ThreadLocal();
    private static final int ID_NO_REPEAT = 1;
    private static final int ID_REPEAT_OBJECT_NEAR = 2;
    private static final int ID_REPEAT_OBJECT_NEARISH = 3;
    private static final int ID_REPEAT_OBJECT_FAR = 4;
    private final boolean hasChildren;

    public InstanceReusingAdvancedExternalizer() {
        this(true);
    }

    public InstanceReusingAdvancedExternalizer(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeObject(ObjectOutput output, T object) throws IOException {
        boolean shouldRemove;
        ReusableData data = cachedWriteObjects.get();
        if (this.hasChildren && data == null) {
            data = new ReusableData();
            cachedWriteObjects.set(data);
            shouldRemove = true;
        } else {
            shouldRemove = false;
        }
        try {
            int id;
            if (data != null && (id = data.map.getOrDefault(object, -1).intValue()) != -1) {
                int diff = id - data.offset;
                if (diff >= -256) {
                    output.write(2);
                    output.write(diff);
                } else if (diff >= -65536) {
                    output.write(3);
                    output.writeShort(diff);
                } else {
                    output.write(4);
                    output.writeInt(id);
                }
            } else {
                output.write(1);
                this.doWriteObject(output, object);
                if (data != null) {
                    data.map.put(object, data.offset++);
                }
            }
        }
        finally {
            if (shouldRemove) {
                cachedWriteObjects.remove();
            }
        }
    }

    public abstract void doWriteObject(ObjectOutput var1, T var2) throws IOException;

    @Override
    public final T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        boolean shouldRemove;
        List<Object> data = cachedReadObjects.get();
        if (this.hasChildren && data == null) {
            data = new ArrayList<Object>();
            cachedReadObjects.set(data);
            shouldRemove = true;
        } else {
            shouldRemove = false;
        }
        try {
            int type = input.read();
            switch (type) {
                case 1: {
                    T object = this.doReadObject(input);
                    if (data != null) {
                        data.add(object);
                    }
                    T t = object;
                    return t;
                }
                case 2: {
                    int offset = input.read() | 0xFFFFFF00;
                    T t = this.getFromCache(data, offset + data.size());
                    return t;
                }
                case 3: {
                    int offset = input.readShort() | 0xFFFF0000;
                    T t = this.getFromCache(data, offset + data.size());
                    return t;
                }
                case 4: {
                    T t = this.getFromCache(data, input.readInt());
                    return t;
                }
            }
            throw new IllegalStateException("Unexpected byte encountered: " + type);
        }
        finally {
            if (shouldRemove) {
                cachedReadObjects.remove();
            }
        }
    }

    private T getFromCache(List<Object> data, int index) throws InvalidObjectException {
        try {
            Object obj = data.get(index);
            if (obj != null) {
                return (T)obj;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new InvalidObjectException("Attempt to read a backreference for " + this.getClass() + " with an invalid ID (absolute " + index + ")");
    }

    public abstract T doReadObject(ObjectInput var1) throws IOException, ClassNotFoundException;

    static class ReusableData {
        Map<Object, Integer> map = new HashMap<Object, Integer>();
        int offset;

        ReusableData() {
        }
    }
}

