/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshallerProvider;

public enum Scalar implements ScalarMarshallerProvider
{
    ANY(new ScalarMarshaller<Object>(){

        @Override
        public Object readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readObject(Any.class).get();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Object value) throws IOException {
            writer.writeObjectNoTag(new Any(value));
        }

        @Override
        public Class<? extends Object> getJavaClass() {
            return Object.class;
        }

        @Override
        public int getWireType() {
            return 2;
        }
    }),
    BOOLEAN(new ScalarMarshaller<Boolean>(){

        @Override
        public Boolean readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readBool();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Boolean value) throws IOException {
            writer.writeBoolNoTag(value);
        }

        @Override
        public Class<? extends Boolean> getJavaClass() {
            return Boolean.class;
        }

        @Override
        public int getWireType() {
            return 0;
        }
    }),
    BYTE(new ScalarMarshaller<Byte>(){

        @Override
        public Byte readFrom(ProtoStreamReader reader) throws IOException {
            return (byte)reader.readSInt32();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Byte value) throws IOException {
            writer.writeSInt32NoTag(value.byteValue());
        }

        @Override
        public Class<? extends Byte> getJavaClass() {
            return Byte.class;
        }

        @Override
        public int getWireType() {
            return 0;
        }
    }),
    SHORT(new ScalarMarshaller<Short>(){

        @Override
        public Short readFrom(ProtoStreamReader reader) throws IOException {
            return (short)reader.readSInt32();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Short value) throws IOException {
            writer.writeSInt32NoTag(value.shortValue());
        }

        @Override
        public Class<? extends Short> getJavaClass() {
            return Short.class;
        }

        @Override
        public int getWireType() {
            return 0;
        }
    }),
    INTEGER(new ScalarMarshaller<Integer>(){

        @Override
        public Integer readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readSInt32();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Integer value) throws IOException {
            writer.writeSInt32NoTag(value);
        }

        @Override
        public Class<? extends Integer> getJavaClass() {
            return Integer.class;
        }

        @Override
        public int getWireType() {
            return 0;
        }
    }),
    LONG(new ScalarMarshaller<Long>(){

        @Override
        public Long readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readSInt64();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Long value) throws IOException {
            writer.writeSInt64NoTag(value);
        }

        @Override
        public Class<? extends Long> getJavaClass() {
            return Long.class;
        }

        @Override
        public int getWireType() {
            return 0;
        }
    }),
    FLOAT(new ScalarMarshaller<Float>(){

        @Override
        public Float readFrom(ProtoStreamReader reader) throws IOException {
            return Float.valueOf(reader.readFloat());
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Float value) throws IOException {
            writer.writeFloatNoTag(value.floatValue());
        }

        @Override
        public Class<? extends Float> getJavaClass() {
            return Float.class;
        }

        @Override
        public int getWireType() {
            return 5;
        }
    }),
    DOUBLE(new ScalarMarshaller<Double>(){

        @Override
        public Double readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readDouble();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Double value) throws IOException {
            writer.writeDoubleNoTag(value);
        }

        @Override
        public Class<? extends Double> getJavaClass() {
            return Double.class;
        }

        @Override
        public int getWireType() {
            return 1;
        }
    }),
    CHARACTER(new ScalarMarshaller<Character>(){

        @Override
        public Character readFrom(ProtoStreamReader reader) throws IOException {
            return Character.valueOf((char)reader.readUInt32());
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Character value) throws IOException {
            writer.writeUInt32NoTag(value.charValue());
        }

        @Override
        public Class<? extends Character> getJavaClass() {
            return Character.class;
        }

        @Override
        public int getWireType() {
            return 0;
        }
    }),
    BYTE_BUFFER(new ScalarMarshaller<ByteBuffer>(){

        @Override
        public ByteBuffer readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readByteBuffer();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, ByteBuffer buffer) throws IOException {
            int offset = buffer.arrayOffset();
            int size = buffer.limit() - offset;
            writer.writeUInt32NoTag(size);
            writer.writeRawBytes(buffer.array(), offset, size);
        }

        @Override
        public Class<? extends ByteBuffer> getJavaClass() {
            return ByteBuffer.class;
        }

        @Override
        public int getWireType() {
            return 2;
        }
    }),
    BYTE_ARRAY(new ScalarMarshaller<byte[]>(){

        @Override
        public byte[] readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readByteArray();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, byte[] value) throws IOException {
            writer.writeUInt32NoTag(value.length);
            writer.writeRawBytes(value, 0, value.length);
        }

        @Override
        public Class<? extends byte[]> getJavaClass() {
            return byte[].class;
        }

        @Override
        public int getWireType() {
            return 2;
        }
    }),
    STRING(new ScalarMarshaller<String>(){

        @Override
        public String readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readString();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, String value) throws IOException {
            writer.writeStringNoTag(value);
        }

        @Override
        public Class<? extends String> getJavaClass() {
            return String.class;
        }

        @Override
        public int getWireType() {
            return 2;
        }
    });

    private final ScalarMarshaller<?> marshaller;

    private Scalar(ScalarMarshaller<?> marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public ScalarMarshaller<?> getMarshaller() {
        return this.marshaller;
    }
}

