/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInputImpl;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;
import org.jboss.resteasy.util.Types;

@Provider
@Consumes(value={"multipart/*"})
public class ListMultipartReader
implements MessageBodyReader<List<?>> {
    @Context
    protected Providers workers;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(List.class) && genericType != null && genericType instanceof ParameterizedType;
    }

    public List<?> readFrom(Class<List<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            throw new IOException(Messages.MESSAGES.unableToGetBoundary());
        }
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException(Messages.MESSAGES.receivedGenericType(this, genericType, ParameterizedType.class));
        }
        ParameterizedType param = (ParameterizedType)genericType;
        Type baseType = param.getActualTypeArguments()[0];
        Class rawType = Types.getRawType((Type)baseType);
        MultipartInputImpl input = new MultipartInputImpl(mediaType, this.workers);
        input.parse(entityStream);
        ArrayList list = new ArrayList();
        for (InputPart part : input.getParts()) {
            list.add(part.getBody(rawType, baseType));
        }
        if (!InputStream.class.equals((Object)rawType)) {
            input.close();
        }
        return list;
    }
}

