/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.resteasy.annotations.providers.multipart.XopWithMultipartRelated;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInputImpl;
import org.jboss.resteasy.plugins.providers.multipart.XopWithMultipartRelatedJAXBProvider;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FindAnnotation;

@Provider
@Consumes(value={"multipart/related"})
public class XopWithMultipartRelatedReader
implements MessageBodyReader<Object> {
    @Context
    protected Providers workers;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return FindAnnotation.findAnnotation((Annotation[])annotations, XopWithMultipartRelated.class) != null || type.isAnnotationPresent(XopWithMultipartRelated.class);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            throw new IOException(Messages.MESSAGES.unableToGetBoundary());
        }
        MultipartRelatedInputImpl input = new MultipartRelatedInputImpl(mediaType, this.workers);
        Providers providers = (Providers)ResteasyProviderFactory.getContextData(Providers.class);
        input.setProviders(providers);
        input.parse(entityStream);
        XopWithMultipartRelatedJAXBProvider xopWithMultipartRelatedJAXBProvider = new XopWithMultipartRelatedJAXBProvider(this.workers);
        return xopWithMultipartRelatedJAXBProvider.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream, input);
    }
}

