/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import org.jboss.resteasy.core.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.core.interception.LegacyPrecedence;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.MessageBodyReaderContext;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;

public class ReaderInterceptorRegistry
extends JaxrsInterceptorRegistry<ReaderInterceptor> {
    protected LegacyPrecedence precedence;

    public ReaderInterceptorRegistry(ResteasyProviderFactory providerFactory, LegacyPrecedence precedence) {
        super(providerFactory, ReaderInterceptor.class);
        this.precedence = precedence;
    }

    public ReaderInterceptorRegistry clone(ResteasyProviderFactory factory) {
        ReaderInterceptorRegistry clone = new ReaderInterceptorRegistry(factory, this.precedence);
        clone.interceptors.addAll(this.interceptors);
        return clone;
    }

    public void registerLegacy(Class<? extends MessageBodyReaderInterceptor> decl) {
        this.register(new JaxrsInterceptorRegistry.LegacyPerMethodInterceptorFactory(decl, this.precedence){

            @Override
            public JaxrsInterceptorRegistry.Match postMatch(Class declaring, AccessibleObject target) {
                Object obj = this.getLegacyMatch(declaring, target);
                if (obj == null) {
                    return null;
                }
                MessageBodyReaderInterceptor interceptor = (MessageBodyReaderInterceptor)obj;
                return new JaxrsInterceptorRegistry.Match(new ReaderInterceptorFacade(interceptor), this.order);
            }
        });
    }

    public void registerLegacy(MessageBodyReaderInterceptor interceptor) {
        this.register(new JaxrsInterceptorRegistry.LegacySingletonInterceptorFactory(interceptor.getClass(), (Object)interceptor, this.precedence){

            @Override
            public JaxrsInterceptorRegistry.Match postMatch(Class declaring, AccessibleObject target) {
                Object obj = this.getLegacyMatch(declaring, target);
                if (obj == null) {
                    return null;
                }
                MessageBodyReaderInterceptor interceptor = (MessageBodyReaderInterceptor)obj;
                return new JaxrsInterceptorRegistry.Match(new ReaderInterceptorFacade(interceptor), this.order);
            }
        });
    }

    public static class ReaderInterceptorFacade
    implements ReaderInterceptor {
        protected final MessageBodyReaderInterceptor interceptor;

        public ReaderInterceptorFacade(MessageBodyReaderInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        public MessageBodyReaderInterceptor getInterceptor() {
            return this.interceptor;
        }

        public Object aroundReadFrom(ReaderInterceptorContext readerInterceptorContext) throws IOException, WebApplicationException {
            MessageBodyReaderContextFacade facade = new MessageBodyReaderContextFacade(readerInterceptorContext);
            return this.interceptor.read(facade);
        }
    }

    private static class MessageBodyReaderContextFacade
    implements MessageBodyReaderContext {
        protected final ReaderInterceptorContext readerInterceptorContext;

        private MessageBodyReaderContextFacade(ReaderInterceptorContext readerInterceptorContext) {
            this.readerInterceptorContext = readerInterceptorContext;
        }

        @Override
        public Class getType() {
            return this.readerInterceptorContext.getType();
        }

        @Override
        public void setType(Class type) {
            this.readerInterceptorContext.setType(type);
        }

        @Override
        public Type getGenericType() {
            return this.readerInterceptorContext.getGenericType();
        }

        @Override
        public void setGenericType(Type genericType) {
            this.readerInterceptorContext.setGenericType(genericType);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.readerInterceptorContext.getAnnotations();
        }

        @Override
        public void setAnnotations(Annotation[] annotations) {
            this.readerInterceptorContext.setAnnotations(annotations);
        }

        @Override
        public MediaType getMediaType() {
            return this.readerInterceptorContext.getMediaType();
        }

        @Override
        public void setMediaType(MediaType mediaType) {
            this.readerInterceptorContext.setMediaType(mediaType);
        }

        @Override
        public MultivaluedMap<String, String> getHeaders() {
            return this.readerInterceptorContext.getHeaders();
        }

        @Override
        public InputStream getInputStream() {
            return this.readerInterceptorContext.getInputStream();
        }

        @Override
        public void setInputStream(InputStream is) {
            this.readerInterceptorContext.setInputStream(is);
        }

        @Override
        public Object getAttribute(String attribute) {
            return this.readerInterceptorContext.getProperty(attribute);
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.readerInterceptorContext.setProperty(name, value);
        }

        @Override
        public void removeAttribute(String name) {
            this.readerInterceptorContext.removeProperty(name);
        }

        @Override
        public Object proceed() throws IOException, WebApplicationException {
            return this.readerInterceptorContext.proceed();
        }
    }
}

