/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.converters.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class UniToMultiPublisher<T>
implements Publisher<T> {
    private final Uni<T> uni;

    public UniToMultiPublisher(Uni<T> uni) {
        this.uni = uni;
    }

    public void subscribe(Subscriber<? super T> downstream) {
        downstream.onSubscribe(new UniToMultiSubscription(this.uni, downstream));
    }

    private static class UniToMultiSubscription<T>
    implements UniSubscription,
    Subscription,
    UniSubscriber<T> {
        private final Uni<T> uni;
        private final Subscriber<? super T> downstream;
        private final AtomicReference<UniSubscription> upstream = new AtomicReference();

        private UniToMultiSubscription(Uni<T> uni, Subscriber<? super T> downstream) {
            this.uni = uni;
            this.downstream = downstream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            UniSubscription sub;
            AtomicReference<UniSubscription> atomicReference = this.upstream;
            synchronized (atomicReference) {
                sub = this.upstream.getAndSet(EmptyUniSubscription.CANCELLED);
            }
            if (sub != null) {
                sub.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            AtomicReference<UniSubscription> atomicReference = this.upstream;
            synchronized (atomicReference) {
                if (n <= 0L) {
                    this.downstream.onError((Throwable)new IllegalArgumentException("Invalid request"));
                    return;
                }
                if (this.upstream.get() == EmptyUniSubscription.CANCELLED) {
                    return;
                }
                AbstractUni.subscribe(this.uni, this);
            }
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            if (!this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onError((Throwable)new IllegalStateException("Invalid subscription state - already have a subscription for upstream"));
            }
        }

        @Override
        public void onItem(T item) {
            if (this.upstream.getAndSet(EmptyUniSubscription.CANCELLED) != EmptyUniSubscription.CANCELLED) {
                if (item != null) {
                    this.downstream.onNext(item);
                }
                this.downstream.onComplete();
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (this.upstream.getAndSet(EmptyUniSubscription.CANCELLED) != EmptyUniSubscription.CANCELLED) {
                this.downstream.onError(failure);
            }
        }
    }
}

