/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.capabilities;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;

class LoggingProfileCapabilityRecorder
implements CapabilityReferenceRecorder {
    private final String dependentName;
    private final String requirementName;
    private final BiFunction<String[], String, Collection<String>> valueConverter;

    LoggingProfileCapabilityRecorder(String dependentName, String requirementName) {
        this(dependentName, requirementName, (values, attributeName) -> Arrays.asList(values));
    }

    LoggingProfileCapabilityRecorder(String dependentName, String requirementName, BiFunction<String[], String, Collection<String>> valueConverter) {
        this.dependentName = dependentName;
        this.requirementName = requirementName;
        this.valueConverter = valueConverter;
    }

    public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
        Collection<String> values = this.valueConverter.apply(attributeValues, attributeName);
        String dependentName = this.getDependentName(context);
        for (String value : values) {
            if (value == null) continue;
            context.registerAdditionalCapabilityRequirement(this.getRequirementName(context, value), dependentName, attributeName);
        }
    }

    public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
        Collection<String> values = this.valueConverter.apply(attributeValues, attributeName);
        String dependentName = this.getDependentName(context);
        for (String value : values) {
            if (value == null) continue;
            context.deregisterCapabilityRequirement(this.getRequirementName(context, value), dependentName, attributeName);
        }
    }

    public String getBaseDependentName() {
        return this.dependentName;
    }

    public String getBaseRequirementName() {
        return this.requirementName;
    }

    public boolean isDynamicDependent() {
        return true;
    }

    public String[] getRequirementPatternSegments(String name, PathAddress address) {
        for (PathElement pathElement : address) {
            if (!"logging-profile".equals(pathElement.getKey())) continue;
            return new String[]{pathElement.getValue(), name};
        }
        return new String[]{name};
    }

    private String getDependentName(OperationContext context) {
        StringBuilder result = new StringBuilder(this.getBaseDependentName());
        for (String name : this.getRequirementPatternSegments(context.getCurrentAddressValue(), context.getCurrentAddress())) {
            result.append('.').append(name);
        }
        return result.toString();
    }

    private String getRequirementName(OperationContext context, String value) {
        StringBuilder result = new StringBuilder(this.getBaseRequirementName());
        for (String name : this.getRequirementPatternSegments(value, context.getCurrentAddress())) {
            result.append('.').append(name);
        }
        return result.toString();
    }
}

