/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.elytron;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.security.SecurityExtension;
import org.jboss.msc.service.ServiceName;

class BasicResourceDefinition
extends SimpleResourceDefinition {
    private final String pathKey;
    private final RuntimeCapability<?> firstCapability;
    private final AttributeDefinition[] attributes;

    BasicResourceDefinition(String pathKey, ResourceDescriptionResolver resourceDescriptionResolver, AbstractAddStepHandler add, AttributeDefinition[] attributes, RuntimeCapability<?> ... runtimeCapabilities) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), resourceDescriptionResolver).setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new ServiceRemoveStepHandler(add, runtimeCapabilities)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(runtimeCapabilities).addAccessConstraints(new AccessConstraintDefinition[]{new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("security", "elytron-security", true, true, true)), new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("security", "elytron-security", false))}));
        this.pathKey = pathKey;
        this.firstCapability = runtimeCapabilities[0];
        this.attributes = attributes;
    }

    BasicResourceDefinition(String pathKey, AbstractAddStepHandler add, AttributeDefinition[] attributes, RuntimeCapability<?> ... runtimeCapabilities) {
        this(pathKey, (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver(pathKey), add, attributes, runtimeCapabilities);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        if (this.attributes != null && this.attributes.length > 0) {
            WriteAttributeHandler write = new WriteAttributeHandler(this.pathKey, this.attributes);
            for (AttributeDefinition current : this.attributes) {
                resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
            }
        }
    }

    private class WriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        WriteAttributeHandler(String parentName, AttributeDefinition ... attributes) {
            super(parentName, attributes);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return BasicResourceDefinition.this.firstCapability.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName();
        }
    }
}

