/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.LockedStream;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.util.EntryWrapper;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.KeyAwareLockPromise;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.function.SerializablePredicate;

public class LockedStreamImpl<K, V>
implements LockedStream<K, V> {
    final CacheStream<CacheEntry<K, V>> realStream;
    final Predicate<? super CacheEntry<K, V>> predicate;
    final long time;
    final TimeUnit unit;

    public LockedStreamImpl(CacheStream<CacheEntry<K, V>> realStream, long time, TimeUnit unit) {
        this.realStream = Objects.requireNonNull(realStream);
        this.predicate = null;
        if (time <= 0L) {
            throw new IllegalArgumentException("time must be greater than 0");
        }
        this.time = time;
        this.unit = Objects.requireNonNull(unit);
    }

    LockedStreamImpl(CacheStream<CacheEntry<K, V>> realStream, Predicate<? super CacheEntry<K, V>> predicate, long time, TimeUnit unit) {
        this.realStream = realStream;
        this.predicate = predicate;
        this.time = time;
        this.unit = unit;
    }

    private LockedStream<K, V> newOrReuse(CacheStream<CacheEntry<K, V>> resultingStream) {
        if (resultingStream == this.realStream) {
            return this;
        }
        return this.newStream(resultingStream, this.predicate, this.time, this.unit);
    }

    LockedStreamImpl<K, V> newStream(CacheStream<CacheEntry<K, V>> realStream, Predicate<? super CacheEntry<K, V>> predicate, long time, TimeUnit unit) {
        return new LockedStreamImpl<K, V>(realStream, predicate, time, unit);
    }

    @Override
    public LockedStream<K, V> filter(Predicate<? super CacheEntry<K, V>> predicate) {
        Objects.nonNull(predicate);
        SerializablePredicate usedPredicate = this.predicate != null ? e -> this.predicate.test((CacheEntry<K, V>)e) && predicate.test(e) : predicate;
        return this.newStream(this.realStream, usedPredicate, this.time, this.unit);
    }

    @Override
    public void forEach(BiConsumer<Cache<K, V>, ? super CacheEntry<K, V>> biConsumer) {
        this.realStream.forEach(new CacheEntryConsumer(biConsumer, this.predicate));
    }

    @Override
    public <R> Map<K, R> invokeAll(BiFunction<Cache<K, V>, ? super CacheEntry<K, V>, R> biFunction) {
        HashMap map = new HashMap();
        Iterator iterator = this.realStream.map(new CacheEntryFunction<K, V, R>(biFunction, this.predicate)).filter(StreamMarshalling.nonNullPredicate()).iterator();
        iterator.forEachRemaining(e -> map.put(e.getKey(), e.getValue()));
        return map;
    }

    @Override
    public LockedStream<K, V> sequentialDistribution() {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.sequentialDistribution());
    }

    @Override
    public LockedStream<K, V> parallelDistribution() {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.parallelDistribution());
    }

    @Override
    public LockedStream<K, V> filterKeySegments(Set<Integer> segments) {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.filterKeySegments((Set)segments));
    }

    @Override
    public LockedStream<K, V> filterKeySegments(IntSet segments) {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.filterKeySegments(segments));
    }

    @Override
    public LockedStream<K, V> filterKeys(Set<?> keys) {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.filterKeys((Set)keys));
    }

    @Override
    public LockedStream<K, V> distributedBatchSize(int batchSize) {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.distributedBatchSize(batchSize));
    }

    @Override
    public LockedStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        throw new UnsupportedOperationException("LockedStream doesn't support completion listener");
    }

    @Override
    public LockedStream<K, V> disableRehashAware() {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.disableRehashAware());
    }

    @Override
    public LockedStream timeout(long timeout, TimeUnit unit) {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.timeout(timeout, unit));
    }

    @Override
    public Iterator<CacheEntry<K, V>> iterator() {
        throw new UnsupportedOperationException("LockedStream doesn't support iterator");
    }

    @Override
    public Spliterator<CacheEntry<K, V>> spliterator() {
        throw new UnsupportedOperationException("LockedStream doesn't support spliterator");
    }

    @Override
    public boolean isParallel() {
        return this.realStream.isParallel();
    }

    @Override
    public LockedStream<K, V> sequential() {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.sequential());
    }

    @Override
    public LockedStream<K, V> parallel() {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.parallel());
    }

    @Override
    public LockedStream<K, V> unordered() {
        return this;
    }

    @Override
    public LockedStream<K, V> onClose(Runnable closeHandler) {
        return this.newOrReuse((CacheStream<CacheEntry<K, V>>)this.realStream.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.realStream.close();
    }

    @SerializeWith(value=Externalizer.class)
    static class CacheEntryConsumer<K, V>
    extends LockHelper<K, V, Void>
    implements BiConsumer<Cache<K, V>, CacheEntry<K, V>> {
        private final BiConsumer<Cache<K, V>, ? super CacheEntry<K, V>> realConsumer;

        private CacheEntryConsumer(BiConsumer<Cache<K, V>, ? super CacheEntry<K, V>> realConsumer, Predicate<? super CacheEntry<K, V>> predicate) {
            super(predicate);
            this.realConsumer = realConsumer;
        }

        @Override
        public void accept(Cache<K, V> kvCache, CacheEntry<K, V> kvCacheEntry) {
            this.perform(kvCache, kvCacheEntry);
        }

        @Override
        protected Void actualPerform(Cache<K, V> cache, CacheEntry<K, V> entry) {
            this.realConsumer.accept(cache, new EntryWrapper<K, V>(cache, entry));
            return null;
        }

        public static final class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<CacheEntryConsumer> {
            public void writeObject(ObjectOutput output, CacheEntryConsumer object) throws IOException {
                output.writeObject(object.realConsumer);
                output.writeObject(object.predicate);
            }

            public CacheEntryConsumer readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new CacheEntryConsumer((BiConsumer)input.readObject(), (Predicate)input.readObject());
            }
        }
    }

    @SerializeWith(value=Externalizer.class)
    @Scope(value=Scopes.NONE)
    static class CacheEntryFunction<K, V, R>
    extends LockHelper<K, V, KeyValuePair<K, R>>
    implements Function<CacheEntry<K, V>, KeyValuePair<K, R>> {
        private final BiFunction<Cache<K, V>, ? super CacheEntry<K, V>, R> biFunction;
        @Inject
        protected transient Cache<K, V> cache;

        protected CacheEntryFunction(BiFunction<Cache<K, V>, ? super CacheEntry<K, V>, R> biFunction, Predicate<? super CacheEntry<K, V>> predicate) {
            super(predicate);
            this.biFunction = biFunction;
        }

        @Override
        public KeyValuePair<K, R> apply(CacheEntry<K, V> kvCacheEntry) {
            return (KeyValuePair)this.perform(this.cache, kvCacheEntry);
        }

        @Override
        protected KeyValuePair<K, R> actualPerform(Cache<K, V> cache, CacheEntry<K, V> entry) {
            return new KeyValuePair<K, R>(entry.getKey(), this.biFunction.apply(cache, entry));
        }

        public static final class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<CacheEntryFunction> {
            public void writeObject(ObjectOutput output, CacheEntryFunction object) throws IOException {
                output.writeObject(object.biFunction);
                output.writeObject(object.predicate);
            }

            public CacheEntryFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new CacheEntryFunction((BiFunction)input.readObject(), (Predicate)input.readObject());
            }
        }
    }

    @Scope(value=Scopes.NONE)
    static abstract class LockHelper<K, V, R> {
        protected final Predicate<? super CacheEntry<K, V>> predicate;
        @Inject
        protected transient LockManager lockManager;

        protected LockHelper(Predicate<? super CacheEntry<K, V>> predicate) {
            this.predicate = predicate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        R perform(Cache<K, V> cache, CacheEntry<K, V> entry) {
            K key = entry.getKey();
            this.lock(key);
            try {
                CacheEntry<K, V> rereadEntry = cache.getAdvancedCache().getCacheEntry(key);
                if (rereadEntry != null && (this.predicate == null || this.predicate.test(rereadEntry))) {
                    AdvancedCache<K, V> cacheToUse = cache.getAdvancedCache().lockAs(key);
                    R r = this.actualPerform(cacheToUse, rereadEntry);
                    return r;
                }
                R r = null;
                return r;
            }
            finally {
                this.lockManager.unlock(key, key);
            }
        }

        protected abstract R actualPerform(Cache<K, V> var1, CacheEntry<K, V> var2);

        private void lock(K key) {
            final KeyAwareLockPromise kalp = this.lockManager.lock(key, key, 10L, TimeUnit.SECONDS);
            if (!kalp.isAvailable()) {
                try {
                    ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                        @Override
                        public boolean block() throws InterruptedException {
                            kalp.lock();
                            return true;
                        }

                        @Override
                        public boolean isReleasable() {
                            return kalp.isAvailable();
                        }
                    });
                }
                catch (InterruptedException e) {
                    throw new CacheException((Throwable)e);
                }
                catch (TimeoutException e) {
                    throw new CacheException("Could not acquire lock for key: " + key + " in 10 seconds");
                }
            }
        }
    }
}

