/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import java.security.PrivilegedAction;
import java.time.Duration;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.cache.Contextual;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryBuilder;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryBuilderServiceNameProvider;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryServiceConfigurator;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorConfiguration;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorFactory;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorFactoryProvider;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DistributableCacheFactoryBuilderServiceConfigurator<K, V extends Identifiable<K> & Contextual<Batch>>
extends DistributableCacheFactoryBuilderServiceNameProvider
implements ServiceConfigurator,
DistributableCacheFactoryBuilder<K, V> {
    private final BeanManagerFactoryServiceConfiguratorFactory factory;
    private final BeanManagerFactoryServiceConfiguratorConfiguration config;

    public DistributableCacheFactoryBuilderServiceConfigurator(String name, BeanManagerFactoryServiceConfiguratorConfiguration config) {
        this(name, DistributableCacheFactoryBuilderServiceConfigurator.load(), config);
    }

    private static BeanManagerFactoryServiceConfiguratorFactoryProvider load() {
        Iterator<BeanManagerFactoryServiceConfiguratorFactoryProvider> providers = DistributableCacheFactoryBuilderServiceConfigurator.load(BeanManagerFactoryServiceConfiguratorFactoryProvider.class).iterator();
        if (!providers.hasNext()) {
            throw new ServiceConfigurationError(BeanManagerFactoryServiceConfiguratorFactoryProvider.class.getName());
        }
        return providers.next();
    }

    private static <T> Iterable<T> load(final Class<T> providerClass) {
        PrivilegedAction action = new PrivilegedAction<Iterable<T>>(){

            @Override
            public Iterable<T> run() {
                return ServiceLoader.load(providerClass, providerClass.getClassLoader());
            }
        };
        return (Iterable)WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
    }

    public DistributableCacheFactoryBuilderServiceConfigurator(String name, BeanManagerFactoryServiceConfiguratorFactoryProvider provider, BeanManagerFactoryServiceConfiguratorConfiguration config) {
        super(name);
        this.config = config;
        this.factory = provider.getBeanManagerFactoryBuilder(name, config);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer cacheFactoryBuilder = builder.provides(new ServiceName[]{name});
        Service service = Service.newInstance((Consumer)cacheFactoryBuilder, (Object)this);
        return builder.setInstance(service);
    }

    @Override
    public BeanManagerFactoryServiceConfiguratorConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public Iterable<CapabilityServiceConfigurator> getDeploymentServiceConfigurators(DeploymentUnit unit) {
        return this.factory.getDeploymentServiceConfigurators(unit.getServiceName());
    }

    @Override
    public CapabilityServiceConfigurator getServiceConfigurator(ServiceName name, final StatefulComponentDescription description, final ComponentConfiguration configuration) {
        BeanContext context = new BeanContext(){

            public String getBeanName() {
                return configuration.getComponentName();
            }

            public ServiceName getDeploymentUnitServiceName() {
                return description.getDeploymentUnitServiceName();
            }

            public ModuleLoader getModuleLoader() {
                return configuration.getModuleLoader();
            }

            public ClassLoader getClassLoader() {
                return configuration.getModuleClassLoader();
            }

            public Duration getTimeout() {
                StatefulTimeoutInfo info = description.getStatefulTimeout();
                if (info == null || info.getValue() < 0L) {
                    return null;
                }
                return Duration.ofMillis(TimeUnit.MILLISECONDS.convert(info.getValue(), info.getTimeUnit()));
            }
        };
        CapabilityServiceConfigurator configurator = this.factory.getBeanManagerFactoryServiceConfigurator(context);
        return new DistributableCacheFactoryServiceConfigurator(name, configurator);
    }

    @Override
    public boolean supportsPassivation() {
        return true;
    }
}

