/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import jakarta.ejb.AccessTimeout;
import jakarta.ejb.Lock;
import jakarta.ejb.LockType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.ConcurrentMethodMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodsMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;

public class EjbConcurrencyMergingProcessor
extends AbstractMergingProcessor<SessionBeanComponentDescription> {
    public EjbConcurrencyMergingProcessor() {
        super(SessionBeanComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, SessionBeanComponentDescription componentConfiguration) {
        RuntimeAnnotationInformation lockData = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, Lock.class);
        for (Map.Entry entry : lockData.getClassAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            componentConfiguration.setBeanLevelLockType((String)entry.getKey(), (LockType)((List)entry.getValue()).get(0));
        }
        for (Map.Entry entry : lockData.getMethodAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            componentConfiguration.setLockType((LockType)((List)entry.getValue()).get(0), MethodIdentifier.getIdentifierForMethod((Method)((Method)entry.getKey())));
        }
        RuntimeAnnotationInformation accessTimeout = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, AccessTimeout.class);
        for (Map.Entry entry : accessTimeout.getClassAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            componentConfiguration.setBeanLevelAccessTimeout((String)entry.getKey(), (AccessTimeoutDetails)((List)entry.getValue()).get(0));
        }
        for (Map.Entry entry : accessTimeout.getMethodAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            componentConfiguration.setAccessTimeout((AccessTimeoutDetails)((List)entry.getValue()).get(0), MethodIdentifier.getIdentifierForMethod((Method)((Method)entry.getKey())));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, SessionBeanComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        if (componentConfiguration.getDescriptorData() == null) {
            return;
        }
        SessionBeanMetaData sessionBeanMetaData = componentConfiguration.getDescriptorData();
        if (sessionBeanMetaData instanceof SessionBean31MetaData) {
            ConcurrentMethodsMetaData methods;
            SessionBean31MetaData descriptor = (SessionBean31MetaData)sessionBeanMetaData;
            if (descriptor.getLockType() != null) {
                componentConfiguration.setBeanLevelLockType(componentConfiguration.getEJBClassName(), descriptor.getLockType());
            }
            if (descriptor.getAccessTimeout() != null) {
                componentConfiguration.setBeanLevelAccessTimeout(componentConfiguration.getEJBClassName(), new AccessTimeoutDetails(descriptor.getAccessTimeout().getTimeout(), descriptor.getAccessTimeout().getUnit()));
            }
            if ((methods = descriptor.getConcurrentMethods()) != null) {
                for (ConcurrentMethodMetaData method : methods) {
                    Method realMethod = this.resolveMethod(deploymentReflectionIndex, componentClass, componentClass, method.getMethod());
                    MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)realMethod);
                    if (method.getLockType() != null) {
                        componentConfiguration.setLockType(method.getLockType(), methodIdentifier);
                    }
                    if (method.getAccessTimeout() == null) continue;
                    componentConfiguration.setAccessTimeout(new AccessTimeoutDetails(method.getAccessTimeout().getTimeout(), method.getAccessTimeout().getUnit()), methodIdentifier);
                }
            }
        }
    }

    private Method resolveMethod(DeploymentReflectionIndex index, Class<?> currentClass, Class<?> componentClass, NamedMethodMetaData methodData) throws DeploymentUnitProcessingException {
        if (currentClass == null) {
            throw EjbLogger.ROOT_LOGGER.failToFindMethodWithParameterTypes(componentClass.getName(), methodData.getMethodName(), methodData.getMethodParams());
        }
        ClassReflectionIndex classIndex = index.getClassIndex(currentClass);
        if (methodData.getMethodParams() == null) {
            Collection methods = classIndex.getAllMethods(methodData.getMethodName());
            if (methods.isEmpty()) {
                return this.resolveMethod(index, currentClass.getSuperclass(), componentClass, methodData);
            }
            if (methods.size() > 1) {
                throw EjbLogger.ROOT_LOGGER.multipleMethodReferencedInEjbJarXml(methodData.getMethodName(), currentClass.getName());
            }
            return (Method)methods.iterator().next();
        }
        Collection methods = classIndex.getAllMethods(methodData.getMethodName(), methodData.getMethodParams().size());
        for (Method method : methods) {
            boolean match = true;
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                if (method.getParameterTypes()[i].getName().equals(methodData.getMethodParams().get(i))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return method;
        }
        return this.resolveMethod(index, currentClass.getSuperclass(), componentClass, methodData);
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

