/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import jakarta.transaction.TransactionManager;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobExecutor;
import org.jberet.spi.JobTask;
import org.jberet.spi.JobXmlResolver;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.batch.jberet.BatchConfiguration;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.ClassLoaderContextHandle;
import org.wildfly.extension.batch.jberet.deployment.ConcurrentContextHandle;
import org.wildfly.extension.batch.jberet.deployment.ContextHandle;
import org.wildfly.extension.batch.jberet.deployment.NamespaceContextHandle;
import org.wildfly.extension.batch.jberet.deployment.SecurityAwareBatchEnvironment;
import org.wildfly.extension.batch.jberet.deployment.SecurityContextHandle;
import org.wildfly.extension.batch.jberet.deployment.WildFlyArtifactFactory;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.transaction.client.ContextTransactionManager;

public class BatchEnvironmentService
implements Service<SecurityAwareBatchEnvironment> {
    private static final Properties PROPS = new Properties();
    private final InjectedValue<WildFlyArtifactFactory> artifactFactoryInjector = new InjectedValue();
    private final InjectedValue<JobExecutor> jobExecutorInjector = new InjectedValue();
    private final InjectedValue<RequestController> requestControllerInjector = new InjectedValue();
    private final InjectedValue<JobRepository> jobRepositoryInjector = new InjectedValue();
    private final InjectedValue<BatchConfiguration> batchConfigurationInjector = new InjectedValue();
    private final ClassLoader classLoader;
    private final JobXmlResolver jobXmlResolver;
    private final String deploymentName;
    private final NamespaceContextSelector namespaceContextSelector;
    private final boolean legacySecurityPresent;
    private SecurityAwareBatchEnvironment batchEnvironment = null;
    private volatile ControlPoint controlPoint;

    public BatchEnvironmentService(ClassLoader classLoader, JobXmlResolver jobXmlResolver, String deploymentName, NamespaceContextSelector namespaceContextSelector, boolean legacySecurityPresent) {
        this.classLoader = classLoader;
        this.jobXmlResolver = jobXmlResolver;
        this.deploymentName = deploymentName;
        this.namespaceContextSelector = namespaceContextSelector;
        this.legacySecurityPresent = legacySecurityPresent;
    }

    public synchronized void start(StartContext context) throws StartException {
        JobRepository jobRepository;
        BatchLogger.LOGGER.debugf("Creating batch environment; %s", this.classLoader);
        BatchConfiguration batchConfiguration = (BatchConfiguration)this.batchConfigurationInjector.getValue();
        JobExecutor jobExecutor = (JobExecutor)this.jobExecutorInjector.getOptionalValue();
        if (jobExecutor == null) {
            jobExecutor = batchConfiguration.getDefaultJobExecutor();
        }
        if ((jobRepository = (JobRepository)this.jobRepositoryInjector.getOptionalValue()) == null) {
            jobRepository = batchConfiguration.getDefaultJobRepository();
        }
        this.batchEnvironment = new WildFlyBatchEnvironment((WildFlyArtifactFactory)this.artifactFactoryInjector.getValue(), jobExecutor, (TransactionManager)ContextTransactionManager.getInstance(), jobRepository, this.jobXmlResolver);
        RequestController requestController = (RequestController)this.requestControllerInjector.getOptionalValue();
        this.controlPoint = requestController != null ? requestController.getControlPoint(this.deploymentName, "batch-executor-service") : null;
    }

    public synchronized void stop(StopContext context) {
        BatchLogger.LOGGER.debugf("Removing batch environment; %s", this.classLoader);
        this.batchEnvironment = null;
        if (this.controlPoint != null) {
            ((RequestController)this.requestControllerInjector.getValue()).removeControlPoint(this.controlPoint);
        }
    }

    public synchronized SecurityAwareBatchEnvironment getValue() throws IllegalStateException, IllegalArgumentException {
        return this.batchEnvironment;
    }

    public InjectedValue<WildFlyArtifactFactory> getArtifactFactoryInjector() {
        return this.artifactFactoryInjector;
    }

    public InjectedValue<JobExecutor> getJobExecutorInjector() {
        return this.jobExecutorInjector;
    }

    public InjectedValue<RequestController> getRequestControllerInjector() {
        return this.requestControllerInjector;
    }

    public InjectedValue<JobRepository> getJobRepositoryInjector() {
        return this.jobRepositoryInjector;
    }

    public InjectedValue<BatchConfiguration> getBatchConfigurationInjector() {
        return this.batchConfigurationInjector;
    }

    private class WildFlyBatchEnvironment
    implements BatchEnvironment,
    SecurityAwareBatchEnvironment {
        private final WildFlyArtifactFactory artifactFactory;
        private final JobExecutor jobExecutor;
        private final TransactionManager transactionManager;
        private final JobRepository jobRepository;
        private final JobXmlResolver jobXmlResolver;

        WildFlyBatchEnvironment(WildFlyArtifactFactory artifactFactory, JobExecutor jobExecutor, TransactionManager transactionManager, JobRepository jobRepository, JobXmlResolver jobXmlResolver) {
            this.jobXmlResolver = jobXmlResolver;
            this.artifactFactory = artifactFactory;
            this.jobExecutor = jobExecutor;
            this.transactionManager = transactionManager;
            this.jobRepository = jobRepository;
        }

        public ClassLoader getClassLoader() {
            return BatchEnvironmentService.this.classLoader;
        }

        public ArtifactFactory getArtifactFactory() {
            return this.artifactFactory;
        }

        public void submitTask(final JobTask jobTask) {
            final SecurityIdentity identity = this.getIdentity();
            final ContextHandle contextHandle = this.createContextHandle();
            JobTask task = new JobTask(){

                public int getRequiredRemainingPermits() {
                    return jobTask.getRequiredRemainingPermits();
                }

                public void run() {
                    ContextHandle.Handle handle = contextHandle.setup();
                    try {
                        if (identity == null) {
                            jobTask.run();
                        } else {
                            identity.runAs((Runnable)jobTask);
                        }
                    }
                    finally {
                        handle.tearDown();
                    }
                }
            };
            if (BatchEnvironmentService.this.controlPoint == null) {
                this.jobExecutor.execute(task);
            } else {
                BatchEnvironmentService.this.controlPoint.queueTask((Runnable)task, (Executor)this.jobExecutor, -1L, null, false);
            }
        }

        public TransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public JobRepository getJobRepository() {
            return this.jobRepository;
        }

        public JobXmlResolver getJobXmlResolver() {
            return this.jobXmlResolver;
        }

        public Properties getBatchConfigurationProperties() {
            return PROPS;
        }

        @Override
        public SecurityDomain getSecurityDomain() {
            return ((BatchConfiguration)BatchEnvironmentService.this.batchConfigurationInjector.getValue()).getSecurityDomain();
        }

        private ContextHandle createContextHandle() {
            ClassLoaderContextHandle classLoaderContextHandle;
            ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            ClassLoaderContextHandle classLoaderContextHandle2 = classLoaderContextHandle = tccl == null ? new ClassLoaderContextHandle(BatchEnvironmentService.this.classLoader) : new ClassLoaderContextHandle(tccl);
            if (BatchEnvironmentService.this.legacySecurityPresent) {
                return new ContextHandle.ChainedContextHandle(classLoaderContextHandle, new NamespaceContextHandle(BatchEnvironmentService.this.namespaceContextSelector), new SecurityContextHandle(), this.artifactFactory.createContextHandle(), new ConcurrentContextHandle());
            }
            return new ContextHandle.ChainedContextHandle(classLoaderContextHandle, new NamespaceContextHandle(BatchEnvironmentService.this.namespaceContextSelector), this.artifactFactory.createContextHandle(), new ConcurrentContextHandle());
        }
    }
}

