/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.remoting3.ConnectionBuilder;
import org.jboss.remoting3.ConnectionProviderFactoryBuilder;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.security.RemotingPermission;
import org.wildfly.common.Assert;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public final class EndpointBuilder {
    private String endpointName;
    private XnioWorker xnioWorker;
    private List<ConnectionProviderFactoryBuilder> connectionProviderFactoryBuilders;
    private List<ConnectionBuilder> connectionBuilders;
    private XnioWorker.Builder workerBuilder;
    private OptionMap defaultConnectionOptionMap = OptionMap.builder().set(RemotingOptions.HEARTBEAT_INTERVAL, 60000).set(Options.READ_TIMEOUT, 120000).set(Options.WRITE_TIMEOUT, 120000).set(Options.KEEP_ALIVE, Boolean.TRUE).getMap();

    EndpointBuilder() {
    }

    public EndpointBuilder setEndpointName(String endpointName) {
        this.endpointName = endpointName;
        return this;
    }

    public EndpointBuilder setXnioWorker(XnioWorker xnioWorker) {
        this.workerBuilder = null;
        this.xnioWorker = xnioWorker;
        return this;
    }

    public XnioWorker.Builder buildXnioWorker(Xnio xnio) {
        this.xnioWorker = null;
        this.workerBuilder = xnio.createWorkerBuilder();
        return this.workerBuilder;
    }

    public ConnectionProviderFactoryBuilder addProvider(String scheme) {
        Assert.checkNotNullParam("scheme", scheme);
        ConnectionProviderFactoryBuilder builder = new ConnectionProviderFactoryBuilder(scheme);
        if (this.connectionProviderFactoryBuilders == null) {
            this.connectionProviderFactoryBuilders = new ArrayList<ConnectionProviderFactoryBuilder>();
        }
        this.connectionProviderFactoryBuilders.add(builder);
        return builder;
    }

    public EndpointBuilder setDefaultConnectionsOptionMap(OptionMap optionMap) {
        OptionMap.Builder optionBuilder = OptionMap.builder();
        optionBuilder.set(RemotingOptions.HEARTBEAT_INTERVAL, optionMap.get(RemotingOptions.HEARTBEAT_INTERVAL, this.defaultConnectionOptionMap.get(RemotingOptions.HEARTBEAT_INTERVAL)));
        optionBuilder.set(Options.READ_TIMEOUT, optionMap.get(Options.READ_TIMEOUT, this.defaultConnectionOptionMap.get(Options.READ_TIMEOUT)));
        optionBuilder.set(Options.WRITE_TIMEOUT, optionMap.get(Options.WRITE_TIMEOUT, this.defaultConnectionOptionMap.get(Options.WRITE_TIMEOUT)));
        optionBuilder.set(Options.KEEP_ALIVE, optionMap.get(Options.KEEP_ALIVE, this.defaultConnectionOptionMap.get(Options.KEEP_ALIVE)));
        this.defaultConnectionOptionMap = optionBuilder.getMap();
        return this;
    }

    public ConnectionBuilder addConnection(URI destination) {
        URI realDestination;
        Assert.checkNotNullParam("destination", destination);
        try {
            realDestination = new URI(destination.getScheme(), null, destination.getHost(), destination.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        ConnectionBuilder builder = new ConnectionBuilder(realDestination);
        if (this.connectionBuilders == null) {
            this.connectionBuilders = new ArrayList<ConnectionBuilder>();
        }
        this.connectionBuilders.add(builder);
        return builder;
    }

    String getEndpointName() {
        return this.endpointName;
    }

    XnioWorker getXnioWorker() {
        return this.xnioWorker;
    }

    XnioWorker.Builder getWorkerBuilder() {
        return this.workerBuilder;
    }

    OptionMap getDefaultConnectionOptionMap() {
        return this.defaultConnectionOptionMap;
    }

    List<ConnectionProviderFactoryBuilder> getConnectionProviderFactoryBuilders() {
        return this.connectionProviderFactoryBuilders;
    }

    List<ConnectionBuilder> getConnectionBuilders() {
        return this.connectionBuilders;
    }

    public Endpoint build() throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(RemotingPermission.CREATE_ENDPOINT);
        }
        try {
            return AccessController.doPrivileged(() -> EndpointImpl.construct(this));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }
}

