/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.InvocationContext;
import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class LifecycleAnnotationParsingProcessor
implements DeploymentUnitProcessor {
    private static final DotName POST_CONSTRUCT_ANNOTATION = DotName.createSimple((String)PostConstruct.class.getName());
    private static final DotName PRE_DESTROY_ANNOTATION = DotName.createSimple((String)PreDestroy.class.getName());
    private static final DotName AROUND_CONSTRUCT_ANNOTATION = DotName.createSimple((String)AroundConstruct.class.getName());
    private static DotName[] LIFE_CYCLE_ANNOTATIONS = new DotName[]{POST_CONSTRUCT_ANNOTATION, PRE_DESTROY_ANNOTATION, AROUND_CONSTRUCT_ANNOTATION};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (DotName annotationName : LIFE_CYCLE_ANNOTATIONS) {
            List lifecycles = index.getAnnotations(annotationName);
            for (AnnotationInstance annotation : lifecycles) {
                this.processLifeCycle(eeModuleDescription, annotation.target(), annotationName, applicationClasses);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processLifeCycle(EEModuleDescription eeModuleDescription, AnnotationTarget target, DotName annotationType, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        if (!(target instanceof MethodInfo)) {
            throw EeLogger.ROOT_LOGGER.methodOnlyAnnotation(annotationType);
        }
        MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
        ClassInfo classInfo = methodInfo.declaringClass();
        EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(classInfo.name().toString());
        Type[] args = methodInfo.args();
        if (args.length > 1) {
            EeLogger.ROOT_LOGGER.warn(EeLogger.ROOT_LOGGER.invalidNumberOfArguments(methodInfo.name(), annotationType, classInfo.name()));
            return;
        }
        if (args.length == 1 && !args[0].name().toString().equals(InvocationContext.class.getName())) {
            EeLogger.ROOT_LOGGER.warn(EeLogger.ROOT_LOGGER.invalidSignature(methodInfo.name(), annotationType, classInfo.name(), "void methodName(InvocationContext ctx)"));
            return;
        }
        InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder(classDescription.getInterceptorClassDescription());
        if (annotationType == POST_CONSTRUCT_ANNOTATION) {
            builder.setPostConstruct(this.getMethodIdentifier(args, methodInfo));
        } else if (annotationType == PRE_DESTROY_ANNOTATION) {
            builder.setPreDestroy(this.getMethodIdentifier(args, methodInfo));
        } else if (annotationType == AROUND_CONSTRUCT_ANNOTATION) {
            builder.setAroundConstruct(this.getMethodIdentifier(args, methodInfo));
        }
        classDescription.setInterceptorClassDescription(builder.build());
    }

    private MethodIdentifier getMethodIdentifier(Type[] args, MethodInfo methodInfo) {
        if (args.length == 0) {
            return MethodIdentifier.getIdentifier(Void.TYPE, (String)methodInfo.name(), (Class[])new Class[0]);
        }
        return MethodIdentifier.getIdentifier((String)methodInfo.returnType().name().toString(), (String)methodInfo.name(), (String[])new String[]{InvocationContext.class.getName()});
    }
}

