/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan.scheduler;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.infinispan.scheduler.Scheduler;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class ScheduleLocalEntriesTask<I, M, K extends Key<I>, V extends M>
implements BiConsumer<Locality, Locality> {
    private final Cache<K, V> cache;
    private final Predicate<Map.Entry<? super K, ? super V>> filter;
    private final Scheduler<I, M> scheduler;

    public ScheduleLocalEntriesTask(Cache<K, V> cache, Predicate<Map.Entry<? super K, ? super V>> filter, Scheduler<I, M> scheduler) {
        this.cache = cache;
        this.filter = filter;
        this.scheduler = scheduler;
    }

    @Override
    public void accept(Locality oldLocality, Locality newLocality) {
        try (CacheStream stream = this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).entrySet().stream().filter(this.filter);){
            Iterator entries = stream.iterator();
            while (entries.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                Map.Entry entry = (Map.Entry)entries.next();
                Key key = (Key)entry.getKey();
                if (oldLocality.isLocal((Object)key) || !newLocality.isLocal((Object)key)) continue;
                this.scheduler.schedule(key.getId(), entry.getValue());
            }
        }
    }
}

