/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import org.wildfly.clustering.Registration;
import org.wildfly.clustering.group.GroupListener;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.LocalNode;
import org.wildfly.clustering.server.group.SingletonMembership;
import org.wildfly.clustering.spi.group.Group;

public abstract class AbstractLocalGroup<A>
implements Group<A>,
Registration {
    private static final String NAME = "local";
    private final Membership membership;

    public AbstractLocalGroup(String nodeName) {
        this.membership = new SingletonMembership(new LocalNode(nodeName));
    }

    public void close() {
    }

    public Registration register(GroupListener listener) {
        return this;
    }

    public String getName() {
        return NAME;
    }

    public Node getLocalMember() {
        return this.membership.getCoordinator();
    }

    public Membership getMembership() {
        return this.membership;
    }

    public boolean isSingleton() {
        return true;
    }

    public Node createNode(A address) {
        return this.getLocalMember();
    }
}

