/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.config;

import java.util.Collections;
import java.util.Map;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;

public class SOAPAddressRewriteMetadata {
    public static final String WEBSERVICE_HOST = "wsdl.soapAddress.rewrite.wsdl-host";
    public static final String WEBSERVICE_PORT = "wsdl.soapAddress.rewrite.wsdl-port";
    public static final String WEBSERVICE_SECURE_PORT = "wsdl.soapAddress.rewrite.wsdl-secure-port";
    public static final String WEBSERVICE_PATH_REWRITE_RULE = "wsdl.soapAddress.rewrite.wsdl-path-rewrite-rule";
    public static final String WEBSERVICE_URI_SCHEME = "wsdl.soapAddress.rewrite.wsdl-uri-scheme";
    public static final String MODIFY_SOAP_ADDRESS = "wsdl.soapAddress.rewrite.modify-wsdl-address";
    private final ServerConfig serverConfig;
    private final Map<String, String> props;

    public SOAPAddressRewriteMetadata(ServerConfig serverConfig, JBossWebservicesMetaData jbwsmd) {
        this.serverConfig = serverConfig;
        Map<String, String> p = jbwsmd != null ? jbwsmd.getProperties() : null;
        this.props = p != null ? p : Collections.emptyMap();
    }

    public String getWebServiceHost() {
        String res = this.props.get(WEBSERVICE_HOST);
        return res != null ? res : this.serverConfig.getWebServiceHost();
    }

    public int getWebServicePort() {
        String res = this.props.get(WEBSERVICE_PORT);
        return res != null ? Integer.parseInt(res) : this.serverConfig.getWebServicePort();
    }

    public int getWebServiceSecurePort() {
        String res = this.props.get(WEBSERVICE_SECURE_PORT);
        return res != null ? Integer.parseInt(res) : this.serverConfig.getWebServiceSecurePort();
    }

    public String getWebServicePathRewriteRule() {
        String res = this.props.get(WEBSERVICE_PATH_REWRITE_RULE);
        return res != null ? res : this.serverConfig.getWebServicePathRewriteRule();
    }

    public String getWebServiceUriScheme() {
        String res = this.props.get(WEBSERVICE_URI_SCHEME);
        return res != null ? res : this.serverConfig.getWebServiceUriScheme();
    }

    public boolean isModifySOAPAddress() {
        String res = this.props.get(MODIFY_SOAP_ADDRESS);
        return res != null ? Boolean.parseBoolean(res) : this.serverConfig.isModifySOAPAddress();
    }
}

