/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.discovery;

import jakarta.xml.ws.Dispatch;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.feature.StaxTransformFeature;
import org.apache.cxf.jaxws.DispatchImpl;

public abstract class WSDVersion {
    public static final String NS_1_0 = "http://schemas.xmlsoap.org/ws/2005/04/discovery";
    public static final String TO_1_0 = "urn:schemas-xmlsoap-org:ws:2005:04:discovery";
    public static final String NS_1_1 = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01";
    public static final String TO_1_1 = "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01";
    public static final WSDVersion INSTANCE_1_0 = new WSDVersion10();
    public static final WSDVersion INSTANCE_1_1 = new WSDVersion11();

    public abstract String getNamespace();

    public abstract String getAddressingNamespace();

    abstract String getToAddress();

    abstract void addVersionTransformer(Dispatch<Object> var1);

    abstract QName getServiceName();

    public String getHelloAction() {
        return this.getNamespace() + "/Hello";
    }

    public String getByeAction() {
        return this.getNamespace() + "/Bye";
    }

    public String getProbeAction() {
        return this.getNamespace() + "/Probe";
    }

    public String getResolveAction() {
        return this.getNamespace() + "/Resolve";
    }

    static final class WSDVersion11
    extends WSDVersion {
        private WSDVersion11() {
        }

        @Override
        public String getNamespace() {
            return WSDVersion.NS_1_1;
        }

        @Override
        public String getToAddress() {
            return WSDVersion.TO_1_1;
        }

        @Override
        public String getAddressingNamespace() {
            return "http://www.w3.org/2005/08/addressing";
        }

        @Override
        public void addVersionTransformer(Dispatch<Object> dispatch) {
            HashMap<String, String> nsMap = new HashMap<String, String>();
            nsMap.put("tns", WSDVersion.NS_1_1);
            nsMap.put("wsa", this.getAddressingNamespace());
            ((DispatchImpl)dispatch).getClient().getEndpoint().getEndpointInfo().setProperty("soap.env.ns.map", nsMap);
        }

        @Override
        public QName getServiceName() {
            return new QName(WSDVersion.NS_1_1, "DiscoveryProxy");
        }
    }

    static final class WSDVersion10
    extends WSDVersion {
        private WSDVersion10() {
        }

        @Override
        public String getNamespace() {
            return WSDVersion.NS_1_0;
        }

        @Override
        public String getToAddress() {
            return WSDVersion.TO_1_0;
        }

        @Override
        public String getAddressingNamespace() {
            return "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        }

        @Override
        public void addVersionTransformer(Dispatch<Object> dispatch) {
            StaxTransformFeature feature = new StaxTransformFeature();
            HashMap<String, String> outElements = new HashMap<String, String>();
            outElements.put("{http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01}*", "{http://schemas.xmlsoap.org/ws/2005/04/discovery}*");
            outElements.put("{" + INSTANCE_1_1.getAddressingNamespace() + "}*", "{" + this.getAddressingNamespace() + "}*");
            feature.setOutTransformElements(outElements);
            HashMap<String, String> inElements = new HashMap<String, String>();
            inElements.put("{http://schemas.xmlsoap.org/ws/2005/04/discovery}*", "{http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01}*");
            inElements.put("{" + this.getAddressingNamespace() + "}*", "{" + INSTANCE_1_1.getAddressingNamespace() + "}*");
            feature.setInTransformElements(inElements);
            feature.initialize(((DispatchImpl)dispatch).getClient(), ((DispatchImpl)dispatch).getClient().getBus());
            HashMap<String, String> nsMap = new HashMap<String, String>();
            nsMap.put("tns", WSDVersion.NS_1_0);
            nsMap.put("wsa", this.getAddressingNamespace());
            ((DispatchImpl)dispatch).getClient().getEndpoint().getEndpointInfo().setProperty("soap.env.ns.map", nsMap);
        }

        @Override
        public QName getServiceName() {
            return new QName(WSDVersion.NS_1_0, "DiscoveryProxy");
        }
    }
}

