/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.URI;
import java.util.LinkedList;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.junit.After;

public class AmqpTestSupport
extends ActiveMQTestBase {
    protected static final int AMQP_PORT = 5672;
    protected LinkedList<AmqpConnection> connections = new LinkedList();
    protected boolean useSSL;
    protected boolean useWebSockets;

    protected AmqpConnection addConnection(AmqpConnection connection) {
        this.connections.add(connection);
        return connection;
    }

    @After
    public void tearDown() throws Exception {
        for (AmqpConnection conn : this.connections) {
            try {
                conn.close();
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
        super.tearDown();
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public boolean isUseWebSockets() {
        return this.useWebSockets;
    }

    public String getAmqpConnectionURIOptions() {
        return "";
    }

    public URI getBrokerAmqpConnectionURI() {
        boolean webSocket = this.isUseWebSockets();
        try {
            int port = 5672;
            String uri = null;
            uri = this.isUseSSL() ? (webSocket ? "wss://127.0.0.1:" + port : "ssl://127.0.0.1:" + port) : (webSocket ? "ws://127.0.0.1:" + port : "tcp://127.0.0.1:" + port);
            if (!this.getAmqpConnectionURIOptions().isEmpty()) {
                uri = uri + "?" + this.getAmqpConnectionURIOptions();
            }
            return new URI(uri);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public AmqpConnection createAmqpConnection() throws Exception {
        return this.createAmqpConnection(this.getBrokerAmqpConnectionURI());
    }

    public AmqpConnection createAmqpConnection(String username, String password) throws Exception {
        return this.createAmqpConnection(this.getBrokerAmqpConnectionURI(), username, password);
    }

    public AmqpConnection createAmqpConnection(URI brokerURI) throws Exception {
        return this.createAmqpConnection(brokerURI, null, null);
    }

    public AmqpConnection createAmqpConnection(URI brokerURI, String username, String password) throws Exception {
        return this.createAmqpClient(brokerURI, username, password).connect();
    }

    public AmqpClient createAmqpClient() throws Exception {
        return this.createAmqpClient(this.getBrokerAmqpConnectionURI(), null, null);
    }

    public AmqpClient createAmqpClient(URI brokerURI) throws Exception {
        return this.createAmqpClient(brokerURI, null, null);
    }

    public AmqpClient createAmqpClient(String username, String password) throws Exception {
        return this.createAmqpClient(this.getBrokerAmqpConnectionURI(), username, password);
    }

    public AmqpClient createAmqpClient(URI brokerURI, String username, String password) throws Exception {
        return new AmqpClient(brokerURI, username, password);
    }

    public static AMQPStandardMessage encodeAndDecodeMessage(int messageFormat, MessageImpl message, int expectedSize) {
        ByteBuf nettyBuffer = Unpooled.buffer((int)expectedSize);
        message.encode((WritableBuffer)new NettyWritable(nettyBuffer));
        byte[] bytes = new byte[nettyBuffer.writerIndex()];
        nettyBuffer.readBytes(bytes);
        return new AMQPStandardMessage((long)messageFormat, bytes, null);
    }
}

