/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.paging;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AmqpPagingTest
extends AmqpClientTestSupport {
    private final Boolean durable;
    private final boolean readWholePage;

    @Parameterized.Parameters(name="durability={0}, readWholePage={1}")
    public static Collection getParams() {
        return Arrays.asList({Boolean.TRUE, true}, {Boolean.TRUE, false}, {Boolean.FALSE, true}, {Boolean.FALSE, false}, {null, true}, {null, false});
    }

    public AmqpPagingTest(Boolean durable, boolean readWholePage) {
        this.durable = durable;
        this.readWholePage = readWholePage;
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        super.addConfiguration(server);
        Map addressesSettings = server.getConfiguration().setReadWholePage(this.readWholePage).getAddressesSettings();
        ((AddressSettings)addressesSettings.get("#")).setMaxSizeBytes(100000L).setPageSizeBytes(10000);
    }

    @Test(timeout=60000L)
    public void testPaging() throws Exception {
        int MSG_SIZE = 1000;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            builder.append('0');
        }
        String data = builder.toString();
        int MSG_COUNT = 1000;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName(), true);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.setPresettle(true);
        receiver.flow(10);
        Assert.assertNull((String)"somehow the queue had messages from a previous test", (Object)receiver.receiveNoWait());
        receiver.flow(0);
        for (int i = 0; i < 1000; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setText(data);
            if (this.durable != null) {
                message.setDurable(this.durable.booleanValue());
            }
            sender.send(message);
        }
        sender.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)1000L, () -> ((Queue)queueView).getMessageCount());
        PagingStore pagingStore = this.server.getPagingManager().getPageStore(SimpleString.toSimpleString((String)this.getQueueName()));
        Assert.assertTrue((boolean)pagingStore.isPaging());
        int pageCacheMaxSize = ((AddressSettings)this.server.getConfiguration().getAddressesSettings().get("#")).getPageCacheMaxSize();
        Assert.assertThat((String)"the size of the messages or the number of messages isn't enough", (Object)pagingStore.getNumberOfPages(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(pageCacheMaxSize)));
        receiver.flow(1000);
        for (int i = 0; i < 1000; ++i) {
            AmqpMessage receive = receiver.receive(10L, TimeUnit.SECONDS);
            AmqpPagingTest.assertNotNull((String)("Not received anything after " + i + " receive"), (Object)receive);
            Assert.assertEquals((Object)(this.durable == null ? false : this.durable), (Object)receive.isDurable());
            receive.accept();
        }
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSizeCalculationsForApplicationProperties() throws Exception {
        int MSG_SIZE = 1000;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            builder.append('0');
        }
        String data = builder.toString();
        boolean MSG_COUNT = true;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName(), true);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "myData IS NOT NULL");
        receiver.setPresettle(true);
        receiver.flow(10);
        Assert.assertNull((String)"somehow the queue had messages from a previous test", (Object)receiver.receiveNoWait());
        receiver.flow(0);
        AmqpMessage message = new AmqpMessage();
        message.setText(data);
        message.setApplicationProperty("myData", (Object)data);
        if (this.durable != null) {
            message.setDurable(this.durable.booleanValue());
        }
        sender.send(message);
        PagingStore pagingStore = this.server.getPagingManager().getPageStore(SimpleString.toSimpleString((String)this.getQueueName()));
        AmqpPagingTest.assertTrue((boolean)Wait.waitFor(() -> pagingStore.getAddressSize() > 3000L));
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(10L, TimeUnit.MINUTES);
        AmqpPagingTest.assertNotNull((String)"Not received anything after receive", (Object)receive);
        receive.accept();
        AmqpPagingTest.assertTrue((boolean)Wait.waitFor(() -> pagingStore.getAddressSize() == 0L));
        message = new AmqpMessage();
        message.setText(data);
        message.setApplicationProperty("_AMQ_DUPL_ID", (Object)"1");
        message.setApplicationProperty("myData", (Object)data);
        if (this.durable != null) {
            message.setDurable(this.durable.booleanValue());
        }
        sender.send(message);
        sender.close();
        AmqpPagingTest.assertTrue((boolean)Wait.waitFor(() -> pagingStore.getAddressSize() > 3000L));
        receiver.flow(1);
        receive = receiver.receive(10L, TimeUnit.MINUTES);
        AmqpPagingTest.assertNotNull((String)"Not received anything after receive", (Object)receive);
        receive.accept();
        receiver.close();
        connection.close();
    }
}

