/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import io.netty.buffer.Unpooled;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.util.NettyReadable;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.junit.Assert;
import org.junit.Test;

public class MessageJournalTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreCore() throws Throwable {
        ActiveMQServer server = this.createServer(true);
        server.start();
        CoreMessage message = new CoreMessage().initBuffer(10240).setDurable(true);
        message.setMessageID(333L);
        CoreProtocolManagerFactory factory = (CoreProtocolManagerFactory)server.getRemotingService().getProtocolFactoryMap().get("CORE");
        Assert.assertNotNull((Object)factory);
        message.getBodyBuffer().writeByte((byte)90);
        server.getStorageManager().storeMessage((Message)message);
        server.getStorageManager().stop();
        JournalStorageManager journalStorageManager = (JournalStorageManager)server.getStorageManager();
        LinkedList committedRecords = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        TransactionFailureCallback transactionFailure = new TransactionFailureCallback(){

            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
            }
        };
        try {
            journalStorageManager.getMessageJournal().start();
            journalStorageManager.getMessageJournal().load(committedRecords, preparedTransactions, transactionFailure);
            Assert.assertEquals((long)1L, (long)committedRecords.size());
        }
        finally {
            journalStorageManager.getMessageJournal().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreAMQP() throws Throwable {
        ActiveMQServer server = this.createServer(true);
        server.start();
        ProtonProtocolManagerFactory factory = (ProtonProtocolManagerFactory)server.getRemotingService().getProtocolFactoryMap().get("AMQP");
        MessageImpl protonJMessage = (MessageImpl)Message.Factory.create();
        AMQPStandardMessage message = this.encodeAndCreateAMQPMessage(protonJMessage);
        message.setMessageID(333L);
        Assert.assertNotNull((Object)factory);
        server.getStorageManager().storeMessage((Message)message);
        server.getStorageManager().stop();
        JournalStorageManager journalStorageManager = (JournalStorageManager)server.getStorageManager();
        LinkedList committedRecords = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        TransactionFailureCallback transactionFailure = new TransactionFailureCallback(){

            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
            }
        };
        try {
            journalStorageManager.getMessageJournal().start();
            journalStorageManager.getMessageJournal().load(committedRecords, preparedTransactions, transactionFailure);
            Assert.assertEquals((long)1L, (long)committedRecords.size());
        }
        finally {
            journalStorageManager.getMessageJournal().stop();
        }
    }

    private AMQPStandardMessage encodeAndCreateAMQPMessage(MessageImpl message) {
        NettyWritable encoded = new NettyWritable(Unpooled.buffer((int)1024));
        message.encode((WritableBuffer)encoded);
        NettyReadable readable = new NettyReadable(encoded.getByteBuf());
        return new AMQPStandardMessage(0L, (ReadableBuffer)readable, null, null);
    }
}

