/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.ra;

import jakarta.resource.spi.InvalidPropertyException;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationValidationUtils;
import org.junit.Assert;
import org.junit.Test;

public class ActiveMQActivationsSpecTest {
    @Test(expected=InvalidPropertyException.class)
    public void nullDestinationName() throws InvalidPropertyException {
        ActiveMQActivationValidationUtils.validate(null, (String)"destinationType", (Boolean)false, (String)"subscriptionName");
    }

    @Test(expected=InvalidPropertyException.class)
    public void emptyDestinationName() throws InvalidPropertyException {
        ActiveMQActivationValidationUtils.validate(null, (String)"destinationType", (Boolean)false, (String)"subscriptionName");
    }

    public void nullDestinationType() throws InvalidPropertyException {
        ActiveMQActivationValidationUtils.validate((String)"destinationName", null, (Boolean)false, (String)"subscriptionName");
    }

    @Test(expected=InvalidPropertyException.class)
    public void emptyDestinationType() throws InvalidPropertyException {
        ActiveMQActivationValidationUtils.validate((String)"destinationName", (String)"", (Boolean)false, (String)"subscriptionName");
    }

    @Test(expected=InvalidPropertyException.class)
    public void subscriptionDurableButNoName() throws InvalidPropertyException {
        ActiveMQActivationValidationUtils.validate((String)"", (String)"", (Boolean)true, (String)"subscriptionName");
    }

    @Test(expected=IllegalArgumentException.class)
    public void validateAcknowledgeMode() {
        Assert.assertEquals((long)ActiveMQActivationValidationUtils.validateAcknowledgeMode((String)"DUPS_OK_ACKNOWLEDGE"), (long)3L);
        Assert.assertEquals((long)ActiveMQActivationValidationUtils.validateAcknowledgeMode((String)"Dups-ok-acknowledge"), (long)3L);
        Assert.assertEquals((long)ActiveMQActivationValidationUtils.validateAcknowledgeMode((String)"AUTO_ACKNOWLEDGE"), (long)1L);
        Assert.assertEquals((long)ActiveMQActivationValidationUtils.validateAcknowledgeMode((String)"Auto-acknowledge"), (long)1L);
        ActiveMQActivationValidationUtils.validateAcknowledgeMode((String)"Invalid Acknowledge Mode");
    }
}

