/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.EnumSet;
import org.infinispan.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.AbstractSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshallerProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ProviderSerializationContextInitializer<E extends Enum<E>>
extends AbstractSerializationContextInitializer {
    private final Class<E> providerClass;

    public ProviderSerializationContextInitializer(String resourceName, Class<E> providerClass) {
        super(resourceName, WildFlySecurityManager.getClassLoaderPrivileged(providerClass));
        this.providerClass = providerClass;
    }

    public void registerMarshallers(SerializationContext context) {
        for (Enum provider : EnumSet.allOf(this.providerClass)) {
            context.registerMarshaller(((ProtoStreamMarshallerProvider)((Object)provider)).getMarshaller());
        }
    }
}

