/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common.impl;

import io.vertx.core.Handler;
import io.vertx.kafka.admin.ConfigEntry;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.ListOffsetsResultInfo;
import io.vertx.kafka.admin.MemberAssignment;
import io.vertx.kafka.admin.NewPartitions;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.client.common.ConfigResource;
import io.vertx.kafka.client.common.Node;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.RecordMetadata;

public class Helper {
    private Helper() {
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        return new HashSet<T>(collection);
    }

    public static org.apache.kafka.common.TopicPartition to(TopicPartition topicPartition) {
        return new org.apache.kafka.common.TopicPartition(topicPartition.getTopic(), topicPartition.getPartition());
    }

    public static Set<org.apache.kafka.common.TopicPartition> to(Set<TopicPartition> topicPartitions) {
        return topicPartitions.stream().map(Helper::to).collect(Collectors.toSet());
    }

    public static Map<org.apache.kafka.common.TopicPartition, org.apache.kafka.clients.consumer.OffsetAndMetadata> to(Map<TopicPartition, OffsetAndMetadata> offsets) {
        return offsets.entrySet().stream().collect(Collectors.toMap(e -> new org.apache.kafka.common.TopicPartition(((TopicPartition)e.getKey()).getTopic(), ((TopicPartition)e.getKey()).getPartition()), e -> new org.apache.kafka.clients.consumer.OffsetAndMetadata(((OffsetAndMetadata)e.getValue()).getOffset(), ((OffsetAndMetadata)e.getValue()).getMetadata())));
    }

    public static Map<String, org.apache.kafka.clients.admin.NewPartitions> toPartitions(Map<String, NewPartitions> newPartitions) {
        return newPartitions.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> org.apache.kafka.clients.admin.NewPartitions.increaseTo((int)((NewPartitions)e.getValue()).getTotalCount(), ((NewPartitions)e.getValue()).getNewAssignments())));
    }

    public static Map<TopicPartition, OffsetAndMetadata> from(Map<org.apache.kafka.common.TopicPartition, org.apache.kafka.clients.consumer.OffsetAndMetadata> offsets) {
        return offsets.entrySet().stream().collect(Collectors.toMap(e -> new TopicPartition(((org.apache.kafka.common.TopicPartition)e.getKey()).topic(), ((org.apache.kafka.common.TopicPartition)e.getKey()).partition()), e -> new OffsetAndMetadata(((org.apache.kafka.clients.consumer.OffsetAndMetadata)e.getValue()).offset(), ((org.apache.kafka.clients.consumer.OffsetAndMetadata)e.getValue()).metadata())));
    }

    public static TopicPartition from(org.apache.kafka.common.TopicPartition topicPartition) {
        return new TopicPartition(topicPartition.topic(), topicPartition.partition());
    }

    public static Set<TopicPartition> from(Collection<org.apache.kafka.common.TopicPartition> topicPartitions) {
        return topicPartitions.stream().map(Helper::from).collect(Collectors.toSet());
    }

    public static Handler<Set<org.apache.kafka.common.TopicPartition>> adaptHandler(Handler<Set<TopicPartition>> handler) {
        if (handler != null) {
            return topicPartitions -> handler.handle(Helper.from(topicPartitions));
        }
        return null;
    }

    public static Node from(org.apache.kafka.common.Node node) {
        return new Node(node.hasRack(), node.host(), node.id(), node.idString(), node.isEmpty(), node.port(), node.rack());
    }

    public static io.vertx.kafka.client.producer.RecordMetadata from(RecordMetadata metadata) {
        return new io.vertx.kafka.client.producer.RecordMetadata(metadata.checksum(), metadata.offset(), metadata.partition(), metadata.timestamp(), metadata.topic());
    }

    public static OffsetAndMetadata from(org.apache.kafka.clients.consumer.OffsetAndMetadata offsetAndMetadata) {
        if (offsetAndMetadata != null) {
            return new OffsetAndMetadata(offsetAndMetadata.offset(), offsetAndMetadata.metadata());
        }
        return null;
    }

    public static org.apache.kafka.clients.consumer.OffsetAndMetadata to(OffsetAndMetadata offsetAndMetadata) {
        return new org.apache.kafka.clients.consumer.OffsetAndMetadata(offsetAndMetadata.getOffset(), offsetAndMetadata.getMetadata());
    }

    public static Map<TopicPartition, Long> fromTopicPartitionOffsets(Map<org.apache.kafka.common.TopicPartition, Long> offsets) {
        return offsets.entrySet().stream().collect(Collectors.toMap(e -> new TopicPartition(((org.apache.kafka.common.TopicPartition)e.getKey()).topic(), ((org.apache.kafka.common.TopicPartition)e.getKey()).partition()), Map.Entry::getValue));
    }

    public static Map<org.apache.kafka.common.TopicPartition, Long> toTopicPartitionTimes(Map<TopicPartition, Long> topicPartitionTimes) {
        return topicPartitionTimes.entrySet().stream().collect(Collectors.toMap(e -> new org.apache.kafka.common.TopicPartition(((TopicPartition)e.getKey()).getTopic(), ((TopicPartition)e.getKey()).getPartition()), Map.Entry::getValue));
    }

    public static Map<TopicPartition, io.vertx.kafka.client.consumer.OffsetAndTimestamp> fromTopicPartitionOffsetAndTimestamp(Map<org.apache.kafka.common.TopicPartition, OffsetAndTimestamp> topicPartitionOffsetAndTimestamps) {
        return topicPartitionOffsetAndTimestamps.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> new TopicPartition(((org.apache.kafka.common.TopicPartition)e.getKey()).topic(), ((org.apache.kafka.common.TopicPartition)e.getKey()).partition()), e -> new io.vertx.kafka.client.consumer.OffsetAndTimestamp(((OffsetAndTimestamp)e.getValue()).offset(), ((OffsetAndTimestamp)e.getValue()).timestamp())));
    }

    public static org.apache.kafka.clients.admin.NewTopic to(NewTopic topic) {
        org.apache.kafka.clients.admin.NewTopic newTopic = null;
        newTopic = topic.getNumPartitions() != -1 && topic.getReplicationFactor() != -1 ? new org.apache.kafka.clients.admin.NewTopic(topic.getName(), topic.getNumPartitions(), topic.getReplicationFactor()) : new org.apache.kafka.clients.admin.NewTopic(topic.getName(), topic.getReplicasAssignments());
        if (topic.getConfig() != null && !topic.getConfig().isEmpty()) {
            newTopic.configs(topic.getConfig());
        }
        return newTopic;
    }

    public static org.apache.kafka.common.config.ConfigResource to(ConfigResource configResource) {
        return new org.apache.kafka.common.config.ConfigResource(configResource.getType(), configResource.getName());
    }

    public static ConfigResource from(org.apache.kafka.common.config.ConfigResource configResource) {
        return new ConfigResource(configResource.type(), configResource.name());
    }

    public static io.vertx.kafka.admin.Config from(Config config) {
        return new io.vertx.kafka.admin.Config(Helper.fromConfigEntries(config.entries()));
    }

    public static List<org.apache.kafka.clients.admin.NewTopic> toNewTopicList(List<NewTopic> topics) {
        return topics.stream().map(Helper::to).collect(Collectors.toList());
    }

    public static List<org.apache.kafka.common.config.ConfigResource> toConfigResourceList(List<ConfigResource> configResources) {
        return configResources.stream().map(Helper::to).collect(Collectors.toList());
    }

    public static org.apache.kafka.clients.admin.ConfigEntry to(ConfigEntry configEntry) {
        return new org.apache.kafka.clients.admin.ConfigEntry(configEntry.getName(), configEntry.getValue());
    }

    public static Map<org.apache.kafka.common.config.ConfigResource, Collection<AlterConfigOp>> toConfigMaps(Map<ConfigResource, io.vertx.kafka.admin.Config> configs) {
        return configs.entrySet().stream().collect(Collectors.toMap(e -> new org.apache.kafka.common.config.ConfigResource(((ConfigResource)e.getKey()).getType(), ((ConfigResource)e.getKey()).getName()), e -> ((io.vertx.kafka.admin.Config)e.getValue()).getEntries().stream().map(v -> new AlterConfigOp(Helper.to(v), AlterConfigOp.OpType.SET)).collect(Collectors.toList())));
    }

    public static ConfigEntry from(org.apache.kafka.clients.admin.ConfigEntry configEntry) {
        return new ConfigEntry(configEntry.name(), configEntry.value());
    }

    public static List<ConfigEntry> fromConfigEntries(Collection<org.apache.kafka.clients.admin.ConfigEntry> configEntries) {
        return configEntries.stream().map(Helper::from).collect(Collectors.toList());
    }

    public static ConsumerGroupListing from(org.apache.kafka.clients.admin.ConsumerGroupListing consumerGroupListing) {
        return new ConsumerGroupListing(consumerGroupListing.groupId(), consumerGroupListing.isSimpleConsumerGroup());
    }

    public static List<ConsumerGroupListing> fromConsumerGroupListings(Collection<org.apache.kafka.clients.admin.ConsumerGroupListing> consumerGroupListings) {
        return consumerGroupListings.stream().map(Helper::from).collect(Collectors.toList());
    }

    public static MemberAssignment from(org.apache.kafka.clients.admin.MemberAssignment memberAssignment) {
        return new MemberAssignment(Helper.from(memberAssignment.topicPartitions()));
    }

    public static ListConsumerGroupOffsetsOptions to(io.vertx.kafka.admin.ListConsumerGroupOffsetsOptions listConsumerGroupOffsetsOptions) {
        ListConsumerGroupOffsetsOptions newListConsumerGroupOffsetsOptions = new ListConsumerGroupOffsetsOptions();
        if (listConsumerGroupOffsetsOptions.topicPartitions() != null) {
            List topicPartitions = listConsumerGroupOffsetsOptions.topicPartitions().stream().map(tp -> new org.apache.kafka.common.TopicPartition(tp.getTopic(), tp.getPartition())).collect(Collectors.toList());
            newListConsumerGroupOffsetsOptions.topicPartitions(topicPartitions);
        }
        return newListConsumerGroupOffsetsOptions;
    }

    public static Set<org.apache.kafka.common.TopicPartition> toTopicPartitionSet(Set<TopicPartition> partitions) {
        return partitions.stream().map(Helper::to).collect(Collectors.toSet());
    }

    public static OffsetSpec to(io.vertx.kafka.admin.OffsetSpec os) {
        if (io.vertx.kafka.admin.OffsetSpec.EARLIEST == os) {
            return OffsetSpec.earliest();
        }
        if (io.vertx.kafka.admin.OffsetSpec.LATEST == os) {
            return OffsetSpec.latest();
        }
        return OffsetSpec.forTimestamp((long)os.getSpec());
    }

    public static Map<org.apache.kafka.common.TopicPartition, OffsetSpec> toTopicPartitionOffsets(Map<TopicPartition, io.vertx.kafka.admin.OffsetSpec> topicPartitionOffsets) {
        return topicPartitionOffsets.entrySet().stream().collect(Collectors.toMap(e -> new org.apache.kafka.common.TopicPartition(((TopicPartition)e.getKey()).getTopic(), ((TopicPartition)e.getKey()).getPartition()), e -> Helper.to((io.vertx.kafka.admin.OffsetSpec)e.getValue())));
    }

    public static ListOffsetsResultInfo from(ListOffsetsResult.ListOffsetsResultInfo lori) {
        return new ListOffsetsResultInfo(lori.offset(), lori.timestamp(), lori.leaderEpoch().orElse(null));
    }
}

