/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SingleRpcCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 1;
    private static final Log log = LogFactory.getLog(SingleRpcCommand.class);
    private VisitableCommand command;

    private SingleRpcCommand() {
        super(null);
    }

    public SingleRpcCommand(ByteString cacheName, VisitableCommand command) {
        super(cacheName);
        this.command = command;
    }

    public SingleRpcCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public byte getCommandId() {
        return 1;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.command);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.command = (VisitableCommand)input.readObject();
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        this.command.init(componentRegistry);
        InvocationContextFactory icf = componentRegistry.getInvocationContextFactory().running();
        InvocationContext ctx = icf.createRemoteInvocationContextForCommand(this.command, this.getOrigin());
        if (this.command instanceof RemoteLockCommand) {
            ctx.setLockOwner(((RemoteLockCommand)((Object)this.command)).getKeyLockOwner());
        }
        if (log.isTraceEnabled()) {
            log.tracef("Invoking command %s, with originLocal flag set to %b", this.command, ctx.isOriginLocal());
        }
        return componentRegistry.getInterceptorChain().running().invokeAsync(ctx, this.command);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleRpcCommand)) {
            return false;
        }
        SingleRpcCommand that = (SingleRpcCommand)o;
        if (Objects.equals(this.cacheName, that.cacheName)) {
            return false;
        }
        return Objects.equals(this.command, that.command);
    }

    public int hashCode() {
        int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
        result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "SingleRpcCommand{cacheName='" + this.cacheName + '\'' + ", command=" + this.command + '}';
    }

    public ReplicableCommand getCommand() {
        return this.command;
    }

    @Override
    public boolean isReturnValueExpected() {
        return this.command.isReturnValueExpected();
    }

    @Override
    public boolean isSuccessful() {
        return this.command.isSuccessful();
    }

    @Override
    public boolean canBlock() {
        return this.command.canBlock();
    }

    @Override
    public boolean logThrowable(Throwable t) {
        return this.command.logThrowable(t);
    }
}

