/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import java.util.Arrays;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;
import org.infinispan.transaction.impl.AbstractCacheTransaction;

public class PessimisticBackupInterceptor
extends BaseBackupInterceptor {
    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        if (PessimisticBackupInterceptor.skipXSiteBackup(command) || !command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.handleSingleKeyWriteReturn);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) {
        throw new IllegalStateException("This should never happen!");
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage stage = this.shouldInvokeRemoteTxCommand(ctx) ? this.backupSender.backupPrepare(command, (AbstractCacheTransaction)ctx.getCacheTransaction(), ctx.getTransaction()) : InvocationStage.completedNullStage();
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            this.keysFromMods(Arrays.stream(rCommand.getModifications())).forEach(key -> this.iracManager.trackUpdatedKey(key.getSegment(), key.getKey(), rCommand.getGlobalTransaction()));
            return stage.thenReturn(rCtx, rCommand, rv);
        });
    }
}

