/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration;

import java.util.UUID;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.tests.util.SingleServerTestBase;
import org.junit.Test;

public class SingleServerSimpleTest
extends SingleServerTestBase {
    @Test
    public void simpleTest() throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        this.session.createQueue(new QueueConfiguration("simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer("simpleAddress");
        ClientMessage message = this.session.createMessage(false);
        message.getBodyBuffer().writeString(data);
        producer.send((Message)message);
        producer.close();
        ClientConsumer consumer = this.session.createConsumer("simpleQueue");
        this.session.start();
        message = consumer.receive(1000L);
        SingleServerSimpleTest.assertNotNull((Object)message);
        message.acknowledge();
        SingleServerSimpleTest.assertEquals((Object)data, (Object)message.getBodyBuffer().readString());
    }
}

