/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageCounterTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString QUEUE = new SimpleString("ConsumerTestQueue");
    private ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testMessageCounter() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(null, null, false, false, false, false, 0);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((Message)message);
        }
        session.commit();
        session.start();
        Assert.assertEquals((long)100L, (long)this.getMessageCount(this.server.getPostOffice(), this.QUEUE.toString()));
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, false);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = consumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            message.acknowledge();
            session.commit();
            Assert.assertEquals((Object)("m" + i), (Object)message.getBodyBuffer().readString());
        }
        session.close();
        Assert.assertEquals((long)0L, (long)this.getMessageCount(this.server.getPostOffice(), this.QUEUE.toString()));
    }
}

