/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.Before;
import org.junit.Test;

public abstract class JmsSendReceiveTestSupport
extends BasicOpenWireTest
implements MessageListener {
    protected int messageCount = 100;
    protected String[] data;
    protected Session session;
    protected Session consumeSession;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected List<Message> messages = Collections.synchronizedList(new ArrayList());
    protected boolean topic = true;
    protected boolean durable;
    protected int deliveryMode = 2;
    protected final Object lock = new Object();
    protected boolean useSeparateSession;

    @Override
    @Before
    public void setUp() throws Exception {
        int i;
        super.setUp();
        String temp = System.getProperty("messageCount");
        if (temp != null && (i = Integer.parseInt(temp)) > 0) {
            this.messageCount = i;
        }
        this.data = new String[this.messageCount];
        for (i = 0; i < this.messageCount; ++i) {
            this.data[i] = "Text for message: " + i + " at " + new Date();
        }
    }

    @Test
    public void testSendReceive() throws Exception {
        this.messages.clear();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            this.producer.send(this.producerDestination, (Message)message);
            this.messageSent();
        }
        this.assertMessagesAreReceived();
    }

    protected void assertMessagesReceivedAreValid(List<Message> receivedMessages) throws JMSException {
        List<Object> copyOfMessages = Arrays.asList(receivedMessages.toArray());
        boolean counter = false;
        if (this.data.length != copyOfMessages.size()) {
            for (TextMessage textMessage : copyOfMessages) {
            }
        }
        JmsSendReceiveTestSupport.assertEquals((String)"Not enough messages received", (long)this.data.length, (long)receivedMessages.size());
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage textMessage = (TextMessage)receivedMessages.get(i);
            String text = textMessage.getText();
            String stringProperty = textMessage.getStringProperty("stringProperty");
            int intProperty = textMessage.getIntProperty("intProperty");
            JmsSendReceiveTestSupport.assertEquals((String)("Message: " + i), (Object)this.data[i], (Object)text);
            JmsSendReceiveTestSupport.assertEquals((Object)this.data[i], (Object)stringProperty);
            JmsSendReceiveTestSupport.assertEquals((long)i, (long)intProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForMessagesToBeDelivered() {
        long maxWaitTime;
        long waitTime = maxWaitTime = 60000L;
        long start = maxWaitTime <= 0L ? 0L : System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while (this.messages.size() < this.data.length && waitTime >= 0L) {
                try {
                    this.lock.wait(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                waitTime = maxWaitTime - (System.currentTimeMillis() - start);
            }
        }
    }

    protected void assertMessagesAreReceived() throws JMSException {
        this.waitForMessagesToBeDelivered();
        this.assertMessagesReceivedAreValid(this.messages);
    }

    protected void messageSent() throws Exception {
    }

    public synchronized void onMessage(Message message) {
        this.consumeMessage(message, this.messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeMessage(Message message, List<Message> messageList) {
        messageList.add(message);
        if (messageList.size() >= this.data.length) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected Message createMessage(int index) throws JMSException {
        TextMessage message = this.session.createTextMessage(this.data[index]);
        return message;
    }

    protected void configureMessage(Message message) throws JMSException {
    }
}

