/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp.util;

import java.io.IOException;
import java.net.URI;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionV10;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionV11;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionV12;

public class StompClientConnectionFactory {
    public static final String LATEST_VERSION = "1.2";

    public static StompClientConnection createClientConnection(String version, String host, int port) throws IOException {
        if ("1.0".equals(version)) {
            return new StompClientConnectionV10(host, port);
        }
        if ("1.1".equals(version)) {
            return new StompClientConnectionV11(host, port);
        }
        if (LATEST_VERSION.equals(version)) {
            return new StompClientConnectionV12(host, port);
        }
        return null;
    }

    public static StompClientConnection createClientConnection(URI uri) throws Exception {
        String version = StompClientConnectionFactory.getStompVersionFromURI(uri);
        if ("1.0".equals(version)) {
            return new StompClientConnectionV10(uri);
        }
        if ("1.1".equals(version)) {
            return new StompClientConnectionV11(uri);
        }
        if (LATEST_VERSION.equals(version)) {
            return new StompClientConnectionV12(uri);
        }
        return null;
    }

    public static StompClientConnection createClientConnection(URI uri, boolean autoConnect) throws Exception {
        String version = StompClientConnectionFactory.getStompVersionFromURI(uri);
        if ("1.0".equals(version)) {
            return new StompClientConnectionV10(uri, autoConnect);
        }
        if ("1.1".equals(version)) {
            return new StompClientConnectionV11(uri, autoConnect);
        }
        if (LATEST_VERSION.equals(version)) {
            return new StompClientConnectionV12(uri, autoConnect);
        }
        return null;
    }

    public static String getStompVersionFromURI(URI uri) {
        String scheme = uri.getScheme();
        if (scheme.contains("10")) {
            return "1.0";
        }
        if (scheme.contains("11")) {
            return "1.1";
        }
        if (scheme.contains("12")) {
            return LATEST_VERSION;
        }
        return LATEST_VERSION;
    }

    public static void main(String[] args) throws Exception {
        StompClientConnection connection = StompClientConnectionFactory.createClientConnection("1.0", "localhost", 61613);
        System.out.println("created a new connection: " + connection);
        connection.connect();
        System.out.println("connected.");
        connection.disconnect();
        System.out.println("Simple stomp client works.");
    }
}

