/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.postoffice.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.ScaleDownHandler;
import org.apache.activemq.artemis.tests.unit.core.postoffice.impl.FakeQueue;
import org.junit.Assert;
import org.junit.Test;

public class QueueComparatorTest {
    @Test
    public void testQueueSorting() {
        FakeQueue queue1 = new FakeQueue(new SimpleString("1"));
        queue1.setMessageCount(1L);
        FakeQueue queue2 = new FakeQueue(new SimpleString("2"));
        queue2.setMessageCount(2L);
        FakeQueue queue3 = new FakeQueue(new SimpleString("3"));
        queue3.setMessageCount(3L);
        ArrayList<FakeQueue> queues = new ArrayList<FakeQueue>();
        queues.add(queue1);
        queues.add(queue2);
        queues.add(queue3);
        Assert.assertEquals((long)1L, (long)((Queue)queues.get(0)).getMessageCount());
        Assert.assertEquals((long)2L, (long)((Queue)queues.get(1)).getMessageCount());
        Assert.assertEquals((long)3L, (long)((Queue)queues.get(2)).getMessageCount());
        Collections.sort(queues, new ScaleDownHandler.OrderQueueByNumberOfReferencesComparator());
        Assert.assertEquals((long)3L, (long)((Queue)queues.get(0)).getMessageCount());
        Assert.assertEquals((long)2L, (long)((Queue)queues.get(1)).getMessageCount());
        Assert.assertEquals((long)1L, (long)((Queue)queues.get(2)).getMessageCount());
    }
}

