/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.integration;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.jbossts.star.logging.RESTATLogger;
import org.jboss.logging.Logger;
import org.jboss.narayana.rest.integration.ParticipantInformation;
import org.jboss.narayana.rest.integration.ParticipantsContainer;
import org.jboss.narayana.rest.integration.api.HeuristicException;
import org.jboss.narayana.rest.integration.api.Participant;
import org.jboss.narayana.rest.integration.api.ParticipantDeserializer;
import org.jboss.narayana.rest.integration.api.ParticipantException;
import org.jboss.narayana.rest.integration.api.ParticipantsManagerFactory;
import org.jboss.narayana.rest.integration.api.PersistableParticipant;

public final class RecoveryManager {
    private static final String PARTICIPANT_INFORMATION_RECORD_TYPE = "/REST-AT/Integration/ParticipantInformationRecoveryRecord";
    private static final Logger LOG = Logger.getLogger(RecoveryManager.class);
    private static final RecoveryManager INSTANCE = new RecoveryManager();
    private final Map<String, ParticipantDeserializer> deserializers = new ConcurrentHashMap<String, ParticipantDeserializer>();
    private final Map<String, Uid> persistedParticipants = new ConcurrentHashMap<String, Uid>();

    private RecoveryManager() {
    }

    public static RecoveryManager getInstance() {
        return INSTANCE;
    }

    public void registerDeserializer(String applicationId, ParticipantDeserializer deserializer) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("RecoveryManager.registerDeserializer: applicationId=" + applicationId + ", deserializer=" + deserializer));
        }
        if (!this.deserializers.containsKey(applicationId)) {
            this.deserializers.put(applicationId, deserializer);
            this.recoverParticipants();
        }
    }

    public void persistParticipantInformation(ParticipantInformation participantInformation) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("RecoveryManager.persistParticipantInformation: participantInformation=" + participantInformation));
        }
        if (!this.isRecoverableParticipant(participantInformation.getParticipant())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"RecoveryManager.persistParticipantInformation: participant is not recoverable");
            }
            return;
        }
        try {
            RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
            OutputObjectState state = this.getParticipantInformationOutputState(participantInformation);
            Uid uid = new Uid(participantInformation.getId());
            recoveryStore.write_committed(uid, PARTICIPANT_INFORMATION_RECORD_TYPE, state);
            this.persistedParticipants.put(participantInformation.getId(), uid);
        }
        catch (Exception e) {
            RESTATLogger.atI18NLogger.warn_persistParticipantInformationRecoveryManager(e.getMessage(), (Throwable)e);
        }
    }

    public void removeParticipantInformation(ParticipantInformation participantInformation) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("RecoveryManager.removeParticipantInformation: participantInformation=" + participantInformation));
        }
        RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
        String participantId = participantInformation.getId();
        if (this.persistedParticipants.get(participantId) != null) {
            try {
                recoveryStore.remove_committed(new Uid(participantId), PARTICIPANT_INFORMATION_RECORD_TYPE);
                this.persistedParticipants.remove(participantId);
            }
            catch (ObjectStoreException ose) {
                RESTATLogger.atI18NLogger.warn_failureRemovingParticipantObjectStore("Failure while removing participant information from the object store.", (Throwable)ose);
            }
        }
    }

    private OutputObjectState getParticipantInformationOutputState(ParticipantInformation participantInformation) throws IOException {
        Uid uid = new Uid(participantInformation.getId());
        OutputObjectState state = new OutputObjectState(uid, PARTICIPANT_INFORMATION_RECORD_TYPE);
        state.packString(participantInformation.getId());
        state.packString(participantInformation.getApplicationId());
        state.packString(participantInformation.getStatus());
        state.packString(participantInformation.getRecoveryURL());
        state.packBytes(this.getParticipantBytes(participantInformation.getParticipant()));
        return state;
    }

    private byte[] getParticipantBytes(Participant participant) throws IOException {
        if (participant instanceof Serializable) {
            return this.serializeParticipant((Serializable)((Object)participant));
        }
        if (participant instanceof PersistableParticipant) {
            return ((PersistableParticipant)((Object)participant)).getRecoveryState();
        }
        return new byte[0];
    }

    private byte[] serializeParticipant(Serializable participant) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(participant);
        return byteArrayOutputStream.toByteArray();
    }

    private boolean isRecoverableParticipant(Participant participant) {
        return participant instanceof Serializable || participant instanceof PersistableParticipant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recoverParticipants() {
        if (ParticipantsManagerFactory.getInstance().getBaseUrl() != null) {
            RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
            InputObjectState states = new InputObjectState();
            try {
                Uid uid;
                if (!recoveryStore.allObjUids(PARTICIPANT_INFORMATION_RECORD_TYPE, states)) return;
                while ((uid = UidHelper.unpackFrom((InputBuffer)states)).notEquals(Uid.nullUid())) {
                    ParticipantInformation participantInformation = this.recreateParticipantInformation(recoveryStore, uid);
                    if (participantInformation == null) continue;
                    ParticipantsContainer.getInstance().addParticipantInformation(participantInformation.getId(), participantInformation);
                    this.persistedParticipants.put(participantInformation.getId(), uid);
                }
                return;
            }
            catch (ObjectStoreException e) {
                RESTATLogger.atI18NLogger.warn_recoverParticipantsRecoveryManager(e.getMessage(), (Throwable)e);
                return;
            }
            catch (IOException e) {
                RESTATLogger.atI18NLogger.warn_ioRecoverParticipantsRecoveryManager(e.getMessage(), (Throwable)e);
                return;
            }
        } else {
            LOG.warn((Object)"Participants cannot be loaded from the object store, because base URL was not set.");
        }
    }

    private ParticipantInformation recreateParticipantInformation(RecoveryStore recoveryStore, Uid uid) throws ObjectStoreException, IOException {
        InputObjectState inputObjectState = recoveryStore.read_committed(uid, PARTICIPANT_INFORMATION_RECORD_TYPE);
        String id = inputObjectState.unpackString();
        if (ParticipantsContainer.getInstance().getParticipantInformation(id) != null) {
            return null;
        }
        String applicationId = inputObjectState.unpackString();
        if (!this.deserializers.containsKey(applicationId)) {
            return null;
        }
        String status = inputObjectState.unpackString();
        String recoveryUrl = inputObjectState.unpackString();
        Participant participant = this.recreateParticipant(inputObjectState, applicationId);
        if (participant == null) {
            return null;
        }
        ParticipantInformation participantInformation = new ParticipantInformation(id, applicationId, recoveryUrl, participant, status);
        this.persistedParticipants.put(participantInformation.getApplicationId(), new Uid(participantInformation.getId()));
        if (!this.synchronizeParticipantUrlWithCoordinator(participantInformation)) {
            try {
                participant.rollback();
                this.removeParticipantInformation(participantInformation);
            }
            catch (HeuristicException e) {
                RESTATLogger.atI18NLogger.warn_heuristicCreateParticipantsRecoveryManager(e.getMessage(), (Throwable)e);
            }
            catch (ParticipantException e) {
                RESTATLogger.atI18NLogger.warn_participantCreateParticipantsRecoveryManager(e.getMessage(), (Throwable)e);
            }
            return null;
        }
        return participantInformation;
    }

    private Participant recreateParticipant(InputObjectState inputObjectState, String applicationId) throws IOException {
        byte[] participantBytes;
        ParticipantDeserializer deserializer = this.deserializers.get(applicationId);
        Participant participant = deserializer.recreate(participantBytes = inputObjectState.unpackBytes());
        if (participant == null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(participantBytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            participant = deserializer.deserialize(objectInputStream);
        }
        return participant;
    }

    private boolean synchronizeParticipantUrlWithCoordinator(ParticipantInformation participantInformation) {
        String participantUrl = this.getParticipantUrl(participantInformation.getId());
        Client client = ClientBuilder.newClient();
        Link participantLink = Link.fromUri((String)participantUrl).title("participant").rel("participant").type("text/plain").build(new Object[0]);
        Link terminatorLink = Link.fromUri((String)participantUrl).title("terminator").rel("terminator").type("text/plain").build(new Object[0]);
        Response response = client.target(participantInformation.getRecoveryURL()).request().header("Link", (Object)participantLink).header("Link", (Object)terminatorLink).put(null);
        try {
            if (response.getStatus() == 404) {
                return false;
            }
        }
        catch (Exception e) {
            RESTATLogger.atI18NLogger.warn_synchronizeParticipantUrlWithCoordinatorRecoveryManager(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private String getParticipantUrl(String participantId) {
        String baseUrl = ParticipantsManagerFactory.getInstance().getBaseUrl();
        if (!baseUrl.substring(baseUrl.length() - 1).equals("/")) {
            baseUrl = baseUrl + "/";
        }
        return baseUrl + "rest-at-participant" + "/" + participantId;
    }
}

