/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import jakarta.transaction.SystemException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.ee.infinispan.InfinispanMutatorFactory;
import org.wildfly.clustering.infinispan.spi.PredicateKeyFilter;
import org.wildfly.clustering.infinispan.spi.listener.PrePassivateListener;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaData;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.cache.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaDataFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public abstract class AbstractInfinispanSessionMetaDataFactory<L>
implements SessionMetaDataFactory<CompositeSessionMetaDataEntry<L>>,
BiFunction<String, Set<Flag>, CompositeSessionMetaDataEntry<L>> {
    private static final Set<Flag> TRY_LOCK_FLAGS = EnumSet.of(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY);
    private final Cache<Key<String>, Object> cache;
    private final Cache<Key<String>, Object> writeCache;
    private final Cache<Key<String>, Object> silentCache;
    private final Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache;
    private final MutatorFactory<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataMutatorFactory;
    private final Cache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;
    private final MutatorFactory<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataMutatorFactory;
    private final CacheProperties properties;
    private final Object evictListener;

    public AbstractInfinispanSessionMetaDataFactory(InfinispanSessionMetaDataFactoryConfiguration configuration) {
        this.cache = configuration.getCache();
        this.writeCache = configuration.getWriteOnlyCache();
        this.silentCache = configuration.getSilentWriteCache();
        this.properties = configuration.getCacheProperties();
        this.creationMetaDataCache = configuration.getCache();
        this.creationMetaDataMutatorFactory = new InfinispanMutatorFactory(this.creationMetaDataCache, this.properties);
        this.accessMetaDataCache = configuration.getCache();
        this.accessMetaDataMutatorFactory = new InfinispanMutatorFactory(this.accessMetaDataCache, this.properties);
        this.evictListener = new PrePassivateListener(this::cascadeEvict, configuration.getExecutor());
        this.cache.addListener(this.evictListener, (CacheEventFilter)new PredicateKeyFilter((Predicate)((Object)SessionCreationMetaDataKeyFilter.INSTANCE)), null);
    }

    public void close() {
        this.cache.removeListener(this.evictListener);
    }

    public CompositeSessionMetaDataEntry<L> createValue(String id, Void context) {
        HashMap<GroupedKey, Object> entries = new HashMap<GroupedKey, Object>(3);
        SessionCreationMetaDataEntry creationMetaDataEntry = new SessionCreationMetaDataEntry((SessionCreationMetaData)new SimpleSessionCreationMetaData());
        entries.put(new SessionCreationMetaDataKey(id), creationMetaDataEntry);
        SimpleSessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
        entries.put(new SessionAccessMetaDataKey(id), accessMetaData);
        this.writeCache.putAll(entries);
        return new CompositeSessionMetaDataEntry(creationMetaDataEntry, (SessionAccessMetaData)accessMetaData);
    }

    public CompositeSessionMetaDataEntry<L> findValue(String id) {
        return (CompositeSessionMetaDataEntry)this.apply(id, EnumSet.noneOf(Flag.class));
    }

    public CompositeSessionMetaDataEntry<L> tryValue(String id) {
        return (CompositeSessionMetaDataEntry)this.apply(id, TRY_LOCK_FLAGS);
    }

    public InvalidatableSessionMetaData createSessionMetaData(String id, CompositeSessionMetaDataEntry<L> entry) {
        boolean newSession = entry.getCreationMetaData().isNew();
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        Mutator creationMutator = this.properties.isTransactional() && newSession ? Mutator.PASSIVE : this.creationMetaDataMutatorFactory.createMutator((Object)creationMetaDataKey, (Object)new SessionCreationMetaDataEntry(entry.getCreationMetaData(), entry.getLocalContext()));
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData(entry.getCreationMetaData(), creationMutator);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        Mutator accessMutator = this.properties.isTransactional() && newSession ? Mutator.PASSIVE : this.accessMetaDataMutatorFactory.createMutator((Object)accessMetaDataKey, (Object)entry.getAccessMetaData());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData(entry.getAccessMetaData(), accessMutator);
        return new CompositeSessionMetaData((SessionCreationMetaData)creationMetaData, (SessionAccessMetaData)accessMetaData);
    }

    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, CompositeSessionMetaDataEntry<L> entry) {
        return new CompositeSessionMetaData(entry.getCreationMetaData(), entry.getAccessMetaData());
    }

    public boolean remove(String id) {
        SessionCreationMetaDataKey key = new SessionCreationMetaDataKey(id);
        try {
            if (!this.properties.isLockOnWrite() || this.creationMetaDataCache.getAdvancedCache().getTransactionManager().getTransaction() == null || this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).lock((Object[])new SessionCreationMetaDataKey[]{key})) {
                return AbstractInfinispanSessionMetaDataFactory.delete(this.writeCache, id);
            }
            return false;
        }
        catch (SystemException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean purge(String id) {
        return AbstractInfinispanSessionMetaDataFactory.delete(this.silentCache, id);
    }

    private static boolean delete(Cache<Key<String>, Object> cache, String id) {
        cache.remove((Object)new SessionAccessMetaDataKey(id));
        cache.remove((Object)new SessionCreationMetaDataKey(id));
        return true;
    }

    private void cascadeEvict(SessionCreationMetaDataKey key, SessionCreationMetaDataEntry<L> value) {
        this.silentCache.evict((Object)new SessionAccessMetaDataKey((String)key.getId()));
    }
}

