/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import jakarta.ejb.CreateException;
import jakarta.ejb.EJBHome;
import jakarta.ejb.Handle;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewService;
import org.jboss.as.ee.component.deployers.AbstractComponentConfigProcessor;
import org.jboss.as.ee.utils.ClassLoadingUtils;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.interceptors.EjbMetadataInterceptor;
import org.jboss.as.ejb3.component.interceptors.HomeRemoveInterceptor;
import org.jboss.as.ejb3.component.interceptors.SessionBeanHomeInterceptorFactory;
import org.jboss.as.ejb3.component.session.InvalidRemoveExceptionMethodInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.msc.service.ServiceBuilder;

public class SessionBeanHomeProcessor
extends AbstractComponentConfigProcessor {
    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, ComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        if (componentDescription instanceof SessionBeanComponentDescription) {
            EjbHomeViewDescription view;
            SessionBeanComponentDescription ejbComponentDescription = (SessionBeanComponentDescription)componentDescription;
            if (ejbComponentDescription.getEjbLocalHomeView() != null) {
                view = ejbComponentDescription.getEjbLocalHomeView();
                EJBViewDescription ejbLocalView = ejbComponentDescription.getEjbLocalView();
                this.configureHome(componentDescription, ejbComponentDescription, view, ejbLocalView);
            }
            if (ejbComponentDescription.getEjbHomeView() != null) {
                view = ejbComponentDescription.getEjbHomeView();
                EJBViewDescription ejbRemoteView = ejbComponentDescription.getEjbRemoteView();
                this.configureHome(componentDescription, ejbComponentDescription, view, ejbRemoteView);
            }
        }
    }

    private void configureHome(final ComponentDescription componentDescription, final SessionBeanComponentDescription ejbComponentDescription, EJBViewDescription homeView, final EJBViewDescription ejbObjectView) {
        homeView.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, final ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addClientPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
                configuration.addClientPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
                for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                    Object factory;
                    if (method.getName().startsWith("create")) {
                        Method initMethod;
                        if (ejbObjectView == null) {
                            throw EjbLogger.ROOT_LOGGER.invalidEjbLocalInterface(componentDescription.getComponentName());
                        }
                        if (ejbComponentDescription instanceof StatelessComponentDescription) {
                            initMethod = null;
                        } else if (ejbComponentDescription instanceof StatefulComponentDescription) {
                            initMethod = SessionBeanHomeProcessor.this.resolveStatefulInitMethod((StatefulComponentDescription)ejbComponentDescription, method);
                            if (initMethod == null) {
                                continue;
                            }
                        } else {
                            throw EjbLogger.ROOT_LOGGER.localHomeNotAllow(ejbComponentDescription);
                        }
                        factory = new SessionBeanHomeInterceptorFactory(initMethod);
                        configuration.getDependencies().add(new DependencyConfigurator<ViewService>((SessionBeanHomeInterceptorFactory)factory){
                            final /* synthetic */ SessionBeanHomeInterceptorFactory val$factory;
                            {
                                this.val$factory = sessionBeanHomeInterceptorFactory;
                            }

                            public void configureDependency(ServiceBuilder<?> serviceBuilder, ViewService service) throws DeploymentUnitProcessingException {
                                serviceBuilder.addDependency(ejbObjectView.getServiceName(), ComponentView.class, this.val$factory.getViewToCreate());
                            }
                        });
                        configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                        configuration.addViewInterceptor(method, (InterceptorFactory)factory, 1536);
                        continue;
                    }
                    if (method.getName().equals("getEJBMetaData") && method.getParameterCount() == 0 && ((EJBViewDescription)description).getMethodIntf() == MethodIntf.HOME) {
                        Class ejbObjectClass;
                        try {
                            ejbObjectClass = ClassLoadingUtils.loadClass((String)ejbObjectView.getViewClassName(), (DeploymentUnit)context.getDeploymentUnit());
                        }
                        catch (ClassNotFoundException e) {
                            throw EjbLogger.ROOT_LOGGER.failedToLoadViewClassForComponent(e, componentDescription.getComponentName());
                        }
                        factory = new EjbMetadataInterceptor(ejbObjectClass, configuration.getViewClass().asSubclass(EJBHome.class), null, true, componentDescription instanceof StatelessComponentDescription);
                        componentConfiguration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>((EjbMetadataInterceptor)factory){
                            final /* synthetic */ EjbMetadataInterceptor val$factory;
                            {
                                this.val$factory = ejbMetadataInterceptor;
                            }

                            public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                                serviceBuilder.addDependency(configuration.getViewServiceName(), ComponentView.class, this.val$factory.getHomeView());
                            }
                        });
                        configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                        configuration.addViewInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)factory), 1536);
                        continue;
                    }
                    if (method.getName().equals("remove") && method.getParameterCount() == 1 && method.getParameterTypes()[0] == Object.class) {
                        configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                        configuration.addViewInterceptor(method, InvalidRemoveExceptionMethodInterceptor.FACTORY, 560);
                        continue;
                    }
                    if (!method.getName().equals("remove") || method.getParameterCount() != 1 || method.getParameterTypes()[0] != Handle.class) continue;
                    configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                    configuration.addViewInterceptor(method, HomeRemoveInterceptor.FACTORY, 1536);
                }
            }
        });
    }

    private Method resolveStatefulInitMethod(StatefulComponentDescription description, Method method) throws DeploymentUnitProcessingException {
        Method initMethod = null;
        for (Map.Entry<Method, String> entry : description.getInitMethods().entrySet()) {
            String name = entry.getValue();
            Method init = entry.getKey();
            if (name == null || !Arrays.equals(init.getParameterTypes(), method.getParameterTypes()) || !init.getName().equals(name)) continue;
            initMethod = init;
        }
        if (initMethod == null) {
            for (Map.Entry entry : description.getInitMethods().entrySet()) {
                Method init = (Method)entry.getKey();
                if (entry.getValue() != null || !Arrays.equals(init.getParameterTypes(), method.getParameterTypes())) continue;
                initMethod = init;
                break;
            }
        }
        if (initMethod == null) {
            for (Class<?> exceptionClass : method.getExceptionTypes()) {
                if (CreateException.class != exceptionClass) continue;
                throw EjbLogger.ROOT_LOGGER.failToCallEjbCreateForHomeInterface(method, description.getEJBClassName());
            }
        }
        return initMethod;
    }
}

