/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.quorum;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FakeServiceComponent;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PluggableQuorumBackupAuthenticationTest
extends FailoverTestBase {
    private static CountDownLatch registrationStarted;
    @Parameterized.Parameter
    public boolean useNetty;

    @Parameterized.Parameters(name="useNetty={1}")
    public static Iterable<Object[]> getParams() {
        return Arrays.asList({false}, {true});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.startBackupServer = false;
        registrationStarted = new CountDownLatch(1);
        super.setUp();
    }

    @Test
    public void testWrongPasswordSetting() throws Exception {
        FakeServiceComponent fakeServiceComponent = new FakeServiceComponent("fake web server");
        Wait.assertTrue(() -> ((ActiveMQServer)this.liveServer.getServer()).isActive());
        this.waitForServerToStart(this.liveServer.getServer());
        this.backupServer.start();
        this.backupServer.getServer().addExternalComponent((ActiveMQComponent)fakeServiceComponent, true);
        PluggableQuorumBackupAuthenticationTest.assertTrue((boolean)registrationStarted.await(5L, TimeUnit.SECONDS));
        Wait.waitFor(() -> !this.backupServer.isStarted());
        PluggableQuorumBackupAuthenticationTest.assertFalse((String)"backup should have stopped", (boolean)this.backupServer.isStarted());
        Wait.assertFalse(fakeServiceComponent::isStarted);
        this.backupServer.stop();
        this.liveServer.stop();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
        this.backupConfig.setClusterPassword("crocodile");
        this.liveConfig.setIncomingInterceptorClassNames(Arrays.asList(NotifyingInterceptor.class.getName()));
        this.backupConfig.setSecurityEnabled(true);
        this.liveConfig.setSecurityEnabled(true);
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.useNetty ? this.getNettyAcceptorTransportConfiguration(live) : TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.useNetty ? this.getNettyConnectorTransportConfiguration(live) : TransportConfigurationUtils.getInVMConnector(live);
    }

    public static final class NotifyingInterceptor
    implements Interceptor {
        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 115) {
                registrationStarted.countDown();
            } else if (packet.getType() == 125) {
                registrationStarted.countDown();
            }
            return true;
        }
    }
}

