/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.quorum;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.component.WebServerComponent;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.apache.activemq.artemis.quorum.MutableLong;
import org.apache.activemq.artemis.quorum.file.FileBasedPrimitiveManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.failover.quorum.PluggableQuorumReplicatedLargeMessageFailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class PluggableQuorumNettyNoGroupNameReplicatedFailoverTest
extends FailoverTest {
    private static final Logger log = Logger.getLogger(PluggableQuorumReplicatedLargeMessageFailoverTest.class);

    protected void beforeWaitForRemoteBackupSynchronization() {
    }

    private void waitForSync(ActiveMQServer server) throws Exception {
        Wait.waitFor(() -> ((ActiveMQServer)server).isReplicaSync());
    }

    @Test(timeout=120000L)
    public void testReplicatedFailback() throws Exception {
        try {
            this.beforeWaitForRemoteBackupSynchronization();
            this.waitForSync(this.backupServer.getServer());
            this.createSessionFactory();
            ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
            session.createQueue(new QueueConfiguration(ADDRESS));
            this.crash(session);
            this.liveServer.start();
            this.waitForSync(this.liveServer.getServer());
            this.waitForSync(this.backupServer.getServer());
            this.waitForServerToStart(this.liveServer.getServer());
            session = this.createSession((ClientSessionFactory)this.sf, true, true);
            this.crash(session);
            this.liveServer.start();
            this.waitForSync(this.liveServer.getServer());
            this.waitForSync(this.backupServer.getServer());
            this.waitForServerToStart(this.liveServer.getServer());
            session = this.createSession((ClientSessionFactory)this.sf, true, true);
            this.crash(session);
            this.liveServer.start();
            this.waitForSync(this.liveServer.getServer());
            this.liveServer.getServer().waitForActivation(5L, TimeUnit.SECONDS);
            this.waitForSync(this.liveServer.getServer());
            this.waitForServerToStart(this.backupServer.getServer());
            PluggableQuorumNettyNoGroupNameReplicatedFailoverTest.assertTrue((boolean)this.backupServer.getServer().isStarted());
        }
        finally {
            if (this.sf != null) {
                this.sf.close();
            }
            try {
                this.liveServer.getServer().stop();
            }
            catch (Throwable throwable) {}
            try {
                this.backupServer.getServer().stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicatedFailbackBackupFromLiveBackToBackup() throws Exception {
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 8787);
        HttpServer httpServer = HttpServer.create(address, 100);
        httpServer.start();
        try {
            httpServer.createContext("/", new HttpHandler(){

                @Override
                public void handle(HttpExchange t) throws IOException {
                    String response = "<html><body><b>This is a unit test</b></body></html>";
                    t.sendResponseHeaders(200, response.length());
                    OutputStream os = t.getResponseBody();
                    os.write(response.getBytes());
                    os.close();
                }
            });
            WebServerDTO wdto = new WebServerDTO();
            AppDTO appDTO = new AppDTO();
            appDTO.war = "console.war";
            appDTO.url = "console";
            wdto.apps = new ArrayList();
            wdto.apps.add(appDTO);
            wdto.bind = "http://localhost:0";
            wdto.path = "console";
            WebServerComponent webServerComponent = new WebServerComponent();
            webServerComponent.configure((ComponentDTO)wdto, ".", ".");
            webServerComponent.start();
            this.backupServer.getServer().getNetworkHealthCheck().parseURIList("http://localhost:8787");
            Assert.assertTrue((boolean)this.backupServer.getServer().getNetworkHealthCheck().isStarted());
            this.backupServer.getServer().addExternalComponent((ActiveMQComponent)webServerComponent, false);
            this.backupServer.getServer().fail(true);
            Assert.assertTrue((boolean)this.backupServer.getServer().getNetworkHealthCheck().isStarted());
            Assert.assertTrue((boolean)((ActiveMQComponent)this.backupServer.getServer().getExternalComponents().get(0)).isStarted());
            ((ServiceComponent)this.backupServer.getServer().getExternalComponents().get(0)).stop(true);
        }
        finally {
            httpServer.stop(0);
        }
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.getNettyAcceptorTransportConfiguration(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.getNettyConnectorTransportConfiguration(live);
    }

    @Override
    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                PluggableQuorumNettyNoGroupNameReplicatedFailoverTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
            }
        } else {
            PluggableQuorumNettyNoGroupNameReplicatedFailoverTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        }
        super.crash(waitFailure, sessions);
    }

    @Override
    protected void crash(ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                PluggableQuorumNettyNoGroupNameReplicatedFailoverTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
            }
        } else {
            PluggableQuorumNettyNoGroupNameReplicatedFailoverTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        }
        super.crash(sessions);
    }

    @Override
    protected void decrementActivationSequenceForForceRestartOf(TestableServer testableServer) throws Exception {
        PluggableQuorumNettyNoGroupNameReplicatedFailoverTest.doDecrementActivationSequenceForForceRestartOf(log, this.nodeManager, this.managerConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDecrementActivationSequenceForForceRestartOf(Logger log, NodeManager nodeManager, DistributedPrimitiveManagerConfiguration distributedPrimitiveManagerConfiguration) throws Exception {
        nodeManager.start();
        long localActivation = nodeManager.readNodeActivationSequence();
        FileBasedPrimitiveManager fileBasedPrimitiveManager = new FileBasedPrimitiveManager(distributedPrimitiveManagerConfiguration.getProperties());
        fileBasedPrimitiveManager.start();
        try {
            MutableLong mutableLong = fileBasedPrimitiveManager.getMutableLong(nodeManager.getNodeId().toString());
            if (!mutableLong.compareAndSet(localActivation + 1L, localActivation)) {
                throw new Exception("Failed to decrement coordinated activation sequence to:" + localActivation + ", not +1 : " + mutableLong.get());
            }
            log.warn((Object)"Intentionally decrementing coordinated activation sequence for test, may result is lost data");
        }
        finally {
            fileBasedPrimitiveManager.stop();
            nodeManager.stop();
        }
    }
}

