/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.json.JsonArray;
import jakarta.json.JsonString;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.api.core.management.RoleInfo;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.cluster.impl.RemoteQueueBindingImpl;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Base64;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AddressControlTest
extends ManagementTestBase {
    private ActiveMQServer server;
    protected ClientSession session;
    private ServerLocator locator;
    private ClientSessionFactory sf;

    public boolean usingCore() {
        return false;
    }

    @Test
    public void testManagementAddressAlwaysExists() throws Exception {
        ClientSession.AddressQuery query = this.session.addressQuery(new SimpleString("activemq.management"));
        AddressControlTest.assertTrue((boolean)query.isExists());
    }

    @Test
    public void testGetAddress() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        AddressControl addressControl = this.createManagementControl(address);
        Assert.assertEquals((Object)address.toString(), (Object)addressControl.getAddress());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testIsRetroactiveResource() throws Exception {
        SimpleString baseAddress = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString address = ResourceNames.getRetroactiveResourceAddressName((String)this.server.getInternalNamingPrefix(), (String)this.server.getConfiguration().getWildcardConfiguration().getDelimiterString(), (SimpleString)baseAddress);
        this.session.createAddress(address, RoutingType.MULTICAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assert.assertTrue((boolean)addressControl.isRetroactiveResource());
    }

    @Test
    public void testGetLocalQueueNames() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString anotherQueue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address));
        RemoteQueueBindingImpl binding = new RemoteQueueBindingImpl(this.server.getStorageManager().generateID(), address, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), Long.valueOf(org.apache.activemq.artemis.utils.RandomUtil.randomLong()), null, null, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), org.apache.activemq.artemis.utils.RandomUtil.randomInt() + 1, MessageLoadBalancingType.OFF);
        this.server.getPostOffice().addBinding((Binding)binding);
        AddressControl addressControl = this.createManagementControl(address);
        String[] queueNames = addressControl.getQueueNames();
        Assert.assertEquals((long)1L, (long)queueNames.length);
        Assert.assertEquals((Object)queue.toString(), (Object)queueNames[0]);
        this.session.createQueue(new QueueConfiguration(anotherQueue).setAddress(address).setDurable(Boolean.valueOf(false)));
        queueNames = addressControl.getQueueNames();
        Assert.assertEquals((long)2L, (long)queueNames.length);
        this.session.deleteQueue(queue);
        queueNames = addressControl.getQueueNames();
        Assert.assertEquals((long)1L, (long)queueNames.length);
        Assert.assertEquals((Object)anotherQueue.toString(), (Object)queueNames[0]);
        this.session.deleteQueue(anotherQueue);
    }

    @Test
    public void testGetRemoteQueueNames() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.MULTICAST, false);
        RemoteQueueBindingImpl binding = new RemoteQueueBindingImpl(this.server.getStorageManager().generateID(), address, queue, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), Long.valueOf(org.apache.activemq.artemis.utils.RandomUtil.randomLong()), null, null, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), org.apache.activemq.artemis.utils.RandomUtil.randomInt() + 1, MessageLoadBalancingType.OFF);
        this.server.getPostOffice().addBinding((Binding)binding);
        AddressControl addressControl = this.createManagementControl(address);
        String[] queueNames = addressControl.getRemoteQueueNames();
        Assert.assertEquals((long)1L, (long)queueNames.length);
        Assert.assertEquals((Object)queue.toString(), (Object)queueNames[0]);
    }

    @Test
    public void testGetAllQueueNames() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString anotherQueue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString remoteQueue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address));
        RemoteQueueBindingImpl binding = new RemoteQueueBindingImpl(this.server.getStorageManager().generateID(), address, remoteQueue, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), Long.valueOf(org.apache.activemq.artemis.utils.RandomUtil.randomLong()), null, null, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), org.apache.activemq.artemis.utils.RandomUtil.randomInt() + 1, MessageLoadBalancingType.OFF);
        this.server.getPostOffice().addBinding((Binding)binding);
        AddressControl addressControl = this.createManagementControl(address);
        String[] queueNames = addressControl.getAllQueueNames();
        Assert.assertEquals((long)2L, (long)queueNames.length);
        Assert.assertTrue((boolean)Arrays.asList(queueNames).contains(queue.toString()));
        Assert.assertTrue((boolean)Arrays.asList(queueNames).contains(remoteQueue.toString()));
        this.session.createQueue(new QueueConfiguration(anotherQueue).setAddress(address).setDurable(Boolean.valueOf(false)));
        queueNames = addressControl.getAllQueueNames();
        Assert.assertEquals((long)3L, (long)queueNames.length);
        Assert.assertTrue((boolean)Arrays.asList(queueNames).contains(anotherQueue.toString()));
        this.session.deleteQueue(queue);
        queueNames = addressControl.getAllQueueNames();
        Assert.assertEquals((long)2L, (long)queueNames.length);
        Assert.assertTrue((boolean)Arrays.asList(queueNames).contains(anotherQueue.toString()));
        Assert.assertFalse((boolean)Arrays.asList(queueNames).contains(queue.toString()));
        this.session.deleteQueue(anotherQueue);
    }

    @Test
    public void testGetBindingNames() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        String divertName = org.apache.activemq.artemis.utils.RandomUtil.randomString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        AddressControl addressControl = this.createManagementControl(address);
        String[] bindingNames = addressControl.getBindingNames();
        AddressControlTest.assertEquals((long)1L, (long)bindingNames.length);
        AddressControlTest.assertEquals((Object)queue.toString(), (Object)bindingNames[0]);
        this.server.getActiveMQServerControl().createDivert(divertName, RandomUtil.randomString(), address.toString(), org.apache.activemq.artemis.utils.RandomUtil.randomString(), false, null, null);
        bindingNames = addressControl.getBindingNames();
        Assert.assertEquals((long)2L, (long)bindingNames.length);
        this.session.deleteQueue(queue);
        bindingNames = addressControl.getBindingNames();
        AddressControlTest.assertEquals((long)1L, (long)bindingNames.length);
        AddressControlTest.assertEquals((Object)divertName.toString(), (Object)bindingNames[0]);
    }

    @Test
    public void testGetRoles() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        Role role = new Role(org.apache.activemq.artemis.utils.RandomUtil.randomString(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean());
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address));
        AddressControl addressControl = this.createManagementControl(address);
        Object[] roles = addressControl.getRoles();
        Assert.assertEquals((long)0L, (long)roles.length);
        HashSet<Role> newRoles = new HashSet<Role>();
        newRoles.add(role);
        this.server.getSecurityRepository().addMatch(address.toString(), newRoles);
        roles = addressControl.getRoles();
        Assert.assertEquals((long)1L, (long)roles.length);
        Object[] r = (Object[])roles[0];
        Assert.assertEquals((Object)role.getName(), (Object)r[0]);
        Assert.assertEquals((Object)CheckType.SEND.hasRole(role), (Object)r[1]);
        Assert.assertEquals((Object)CheckType.CONSUME.hasRole(role), (Object)r[2]);
        Assert.assertEquals((Object)CheckType.CREATE_DURABLE_QUEUE.hasRole(role), (Object)r[3]);
        Assert.assertEquals((Object)CheckType.DELETE_DURABLE_QUEUE.hasRole(role), (Object)r[4]);
        Assert.assertEquals((Object)CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role), (Object)r[5]);
        Assert.assertEquals((Object)CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role), (Object)r[6]);
        Assert.assertEquals((Object)CheckType.MANAGE.hasRole(role), (Object)r[7]);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetRolesAsJSON() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        Role role = new Role(org.apache.activemq.artemis.utils.RandomUtil.randomString(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean());
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address));
        AddressControl addressControl = this.createManagementControl(address);
        String jsonString = addressControl.getRolesAsJSON();
        Assert.assertNotNull((Object)jsonString);
        RoleInfo[] roles = RoleInfo.from((String)jsonString);
        Assert.assertEquals((long)0L, (long)roles.length);
        HashSet<Role> newRoles = new HashSet<Role>();
        newRoles.add(role);
        this.server.getSecurityRepository().addMatch(address.toString(), newRoles);
        jsonString = addressControl.getRolesAsJSON();
        Assert.assertNotNull((Object)jsonString);
        roles = RoleInfo.from((String)jsonString);
        Assert.assertEquals((long)1L, (long)roles.length);
        RoleInfo r = roles[0];
        Assert.assertEquals((Object)role.getName(), (Object)roles[0].getName());
        Assert.assertEquals((Object)role.isSend(), (Object)r.isSend());
        Assert.assertEquals((Object)role.isConsume(), (Object)r.isConsume());
        Assert.assertEquals((Object)role.isCreateDurableQueue(), (Object)r.isCreateDurableQueue());
        Assert.assertEquals((Object)role.isDeleteDurableQueue(), (Object)r.isDeleteDurableQueue());
        Assert.assertEquals((Object)role.isCreateNonDurableQueue(), (Object)r.isCreateNonDurableQueue());
        Assert.assertEquals((Object)role.isDeleteNonDurableQueue(), (Object)r.isDeleteNonDurableQueue());
        Assert.assertEquals((Object)role.isManage(), (Object)r.isManage());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetNumberOfPages() throws Exception {
        ClientMessage msg;
        this.session.close();
        this.server.stop();
        this.server.getConfiguration().setPersistenceEnabled(true);
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setPageSizeBytes(1024).setMaxSizeBytes(10240L);
        int NUMBER_MESSAGES_BEFORE_PAGING = 7;
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.server.start();
        ServerLocator locator2 = this.createInVMNonHALocator();
        this.addServerLocator(locator2);
        ClientSessionFactory sf2 = this.createSessionFactory(locator2);
        this.session = sf2.createSession(false, true, false);
        this.session.start();
        this.session.createQueue(new QueueConfiguration(address));
        QueueImpl serverQueue = (QueueImpl)this.server.locateQueue(address);
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 7; ++i) {
            msg = this.session.createMessage(true);
            msg.getBodyBuffer().writeBytes(new byte[896]);
            producer.send((Message)msg);
        }
        this.session.commit();
        AddressControl addressControl = this.createManagementControl(address);
        Assert.assertEquals((long)0L, (long)addressControl.getNumberOfPages());
        msg = this.session.createMessage(true);
        msg.getBodyBuffer().writeBytes(new byte[896]);
        producer.send((Message)msg);
        this.session.commit();
        Assert.assertEquals((long)1L, (long)addressControl.getNumberOfPages());
        msg = this.session.createMessage(true);
        msg.getBodyBuffer().writeBytes(new byte[896]);
        producer.send((Message)msg);
        this.session.commit();
        Assert.assertEquals((long)1L, (long)addressControl.getNumberOfPages());
        msg = this.session.createMessage(true);
        msg.getBodyBuffer().writeBytes(new byte[896]);
        producer.send((Message)msg);
        this.session.commit();
        Assert.assertEquals((String)"# of pages is 2", (long)2L, (long)addressControl.getNumberOfPages());
        Assert.assertEquals((long)serverQueue.getPageSubscription().getPagingStore().getAddressSize(), (long)addressControl.getAddressSize());
    }

    @Test
    public void testGetNumberOfBytesPerPage() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(address));
        AddressControl addressControl = this.createManagementControl(address);
        Assert.assertEquals((long)0xA00000L, (long)addressControl.getNumberOfBytesPerPage());
        this.session.close();
        this.server.stop();
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setPageSizeBytes(1024);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.server.start();
        ServerLocator locator2 = this.createInVMNonHALocator();
        ClientSessionFactory sf2 = this.createSessionFactory(locator2);
        this.session = sf2.createSession(false, true, false);
        this.session.createQueue(new QueueConfiguration(address));
        Assert.assertEquals((long)1024L, (long)addressControl.getNumberOfBytesPerPage());
    }

    @Test
    public void testGetRoutingTypes() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        String[] routingTypes = addressControl.getRoutingTypes();
        Assert.assertEquals((long)1L, (long)routingTypes.length);
        Assert.assertEquals((Object)RoutingType.ANYCAST.toString(), (Object)routingTypes[0]);
        address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        EnumSet<RoutingType> types = EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST);
        this.session.createAddress(address, types, false);
        addressControl = this.createManagementControl(address);
        routingTypes = addressControl.getRoutingTypes();
        HashSet<String> strings = new HashSet<String>(Arrays.asList(routingTypes));
        Assert.assertEquals((long)2L, (long)strings.size());
        Assert.assertTrue((boolean)strings.contains(RoutingType.ANYCAST.toString()));
        Assert.assertTrue((boolean)strings.contains(RoutingType.MULTICAST.toString()));
    }

    @Test
    public void testGetRoutingTypesAsJSON() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        JsonArray jsonArray = JsonUtil.readJsonArray((String)addressControl.getRoutingTypesAsJSON());
        AddressControlTest.assertEquals((long)1L, (long)jsonArray.size());
        AddressControlTest.assertEquals((Object)RoutingType.ANYCAST.toString(), (Object)((JsonString)jsonArray.get(0)).getString());
    }

    @Test
    public void testGetMessageCount() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        AddressControlTest.assertEquals((long)0L, (long)addressControl.getMessageCount());
        ClientProducer producer = this.session.createProducer(address.toString());
        producer.send((Message)this.session.createMessage(false));
        AddressControlTest.assertEquals((long)0L, (long)addressControl.getMessageCount());
        this.session.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST));
        producer.send((Message)this.session.createMessage(false));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getMessageCount() == 1L, (long)2000L, (long)100L));
        this.session.createQueue(new QueueConfiguration(address.concat('2')).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        producer.send((Message)this.session.createMessage(false));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getMessageCount() == 2L, (long)2000L, (long)100L));
    }

    @Test
    public void testGetRoutedMessageCounts() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        AddressControlTest.assertEquals((long)0L, (long)addressControl.getMessageCount());
        ClientProducer producer = this.session.createProducer(address.toString());
        producer.send((Message)this.session.createMessage(false));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getRoutedMessageCount() == 0L, (long)2000L, (long)100L));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getUnRoutedMessageCount() == 1L, (long)2000L, (long)100L));
        this.session.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST));
        producer.send((Message)this.session.createMessage(false));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getRoutedMessageCount() == 1L, (long)2000L, (long)100L));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getUnRoutedMessageCount() == 1L, (long)2000L, (long)100L));
        this.session.createQueue(new QueueConfiguration(address.concat('2')).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        producer.send((Message)this.session.createMessage(false));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getRoutedMessageCount() == 2L, (long)2000L, (long)100L));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getUnRoutedMessageCount() == 1L, (long)2000L, (long)100L));
        this.session.deleteQueue(address);
        this.session.deleteQueue(address.concat('2'));
        producer.send((Message)this.session.createMessage(false));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getRoutedMessageCount() == 2L, (long)2000L, (long)100L));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getUnRoutedMessageCount() == 2L, (long)2000L, (long)100L));
    }

    @Test
    public void testSendMessage() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assert.assertEquals((long)0L, (long)addressControl.getQueueNames().length);
        this.session.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST));
        Assert.assertEquals((long)1L, (long)addressControl.getQueueNames().length);
        addressControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null);
        Wait.waitFor(() -> addressControl.getMessageCount() == 1L);
        Assert.assertEquals((long)1L, (long)addressControl.getMessageCount());
        ClientConsumer consumer = this.session.createConsumer(address);
        ClientMessage message = consumer.receive(500L);
        AddressControlTest.assertNotNull((Object)message);
        byte[] buffer = new byte[message.getBodyBuffer().readableBytes()];
        message.getBodyBuffer().readBytes(buffer);
        AddressControlTest.assertEquals((Object)"test", (Object)new String(buffer));
    }

    @Test
    public void testSendMessageWithProperties() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assert.assertEquals((long)0L, (long)addressControl.getQueueNames().length);
        this.session.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST));
        Assert.assertEquals((long)1L, (long)addressControl.getQueueNames().length);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("myProp1", "myValue1");
        headers.put("myProp2", "myValue2");
        addressControl.sendMessage(headers, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null);
        Wait.waitFor(() -> addressControl.getMessageCount() == 1L);
        Assert.assertEquals((long)1L, (long)addressControl.getMessageCount());
        ClientConsumer consumer = this.session.createConsumer(address);
        ClientMessage message = consumer.receive(500L);
        AddressControlTest.assertNotNull((Object)message);
        byte[] buffer = new byte[message.getBodyBuffer().readableBytes()];
        message.getBodyBuffer().readBytes(buffer);
        AddressControlTest.assertEquals((Object)"test", (Object)new String(buffer));
        AddressControlTest.assertEquals((Object)"myValue1", (Object)message.getStringProperty("myProp1"));
        AddressControlTest.assertEquals((Object)"myValue2", (Object)message.getStringProperty("myProp2"));
    }

    @Test
    public void testSendMessageWithMessageId() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assert.assertEquals((long)0L, (long)addressControl.getQueueNames().length);
        this.session.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST));
        Assert.assertEquals((long)1L, (long)addressControl.getQueueNames().length);
        addressControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null, true);
        addressControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null, false);
        Wait.waitFor(() -> addressControl.getMessageCount() == 2L);
        Assert.assertEquals((long)2L, (long)addressControl.getMessageCount());
        ClientConsumer consumer = this.session.createConsumer(address);
        ClientMessage message = consumer.receive(500L);
        AddressControlTest.assertNotNull((Object)message);
        AddressControlTest.assertNotNull((Object)message.getUserID());
        byte[] buffer = new byte[message.getBodyBuffer().readableBytes()];
        message.getBodyBuffer().readBytes(buffer);
        AddressControlTest.assertEquals((Object)"test", (Object)new String(buffer));
        message = consumer.receive(500L);
        AddressControlTest.assertNotNull((Object)message);
        AddressControlTest.assertNull((Object)message.getUserID());
        buffer = new byte[message.getBodyBuffer().readableBytes()];
        message.getBodyBuffer().readBytes(buffer);
        AddressControlTest.assertEquals((Object)"test", (Object)new String(buffer));
    }

    @Test
    public void testGetCurrentDuplicateIdCacheSize() throws Exception {
        this.internalDuplicateIdTest(false);
    }

    @Test
    public void testClearDuplicateIdCache() throws Exception {
        this.internalDuplicateIdTest(true);
    }

    private void internalDuplicateIdTest(boolean clear) throws Exception {
        this.server.getConfiguration().setPersistIDCache(false);
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assert.assertEquals((long)0L, (long)addressControl.getQueueNames().length);
        this.session.createQueue(address, RoutingType.ANYCAST, address);
        Assert.assertEquals((long)1L, (long)addressControl.getQueueNames().length);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Message.HDR_DUPLICATE_DETECTION_ID.toString(), UUID.randomUUID().toString());
        addressControl.sendMessage(headers, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null);
        addressControl.sendMessage(headers, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null);
        headers.clear();
        headers.put(Message.HDR_DUPLICATE_DETECTION_ID.toString(), UUID.randomUUID().toString());
        addressControl.sendMessage(headers, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null);
        Wait.assertTrue(() -> addressControl.getCurrentDuplicateIdCacheSize() == 2L);
        if (clear) {
            AddressControlTest.assertTrue((boolean)addressControl.clearDuplicateIdCache());
            Wait.assertTrue(() -> addressControl.getCurrentDuplicateIdCacheSize() == 0L);
        }
    }

    @Test
    public void testPurge() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        AddressControlTest.assertEquals((long)0L, (long)addressControl.getMessageCount());
        ClientProducer producer = this.session.createProducer(address.toString());
        producer.send((Message)this.session.createMessage(false));
        AddressControlTest.assertEquals((long)0L, (long)addressControl.getMessageCount());
        this.session.createQueue(new QueueConfiguration(address).setRoutingType(RoutingType.ANYCAST));
        producer.send((Message)this.session.createMessage(false));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getMessageCount() == 1L, (long)2000L, (long)100L));
        this.session.createQueue(new QueueConfiguration(address.concat('2')).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        producer.send((Message)this.session.createMessage(false));
        AddressControlTest.assertTrue((boolean)Wait.waitFor(() -> addressControl.getMessageCount() == 2L, (long)2000L, (long)100L));
        AddressControlTest.assertEquals((long)2L, (long)addressControl.purge());
        Wait.assertEquals((Long)0L, () -> addressControl.getMessageCount(), (long)2000L, (long)100L);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultInVMConfig().setJMXManagementEnabled(true);
        this.server = this.createServer(false, config);
        this.server.setMBeanServer(this.mbeanServer);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, false);
        this.session.start();
        this.addClientSession(this.session);
    }

    protected AddressControl createManagementControl(SimpleString address) throws Exception {
        return ManagementControlHelper.createAddressControl(address, this.mbeanServer);
    }
}

