/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import jakarta.jms.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.jboss.as.server.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSQueueService
implements Service<Queue> {
    static final String JMS_QUEUE_PREFIX = "jms.queue.";
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final String queueName;
    private final String selectorString;
    private final boolean durable;
    private Queue queue;

    public JMSQueueService(String name, String selectorString, boolean durable) {
        this.queueName = name.startsWith(JMS_QUEUE_PREFIX) ? name.substring(JMS_QUEUE_PREFIX.length()) : name;
        this.selectorString = selectorString;
        this.durable = durable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(final StartContext context) throws StartException {
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.createQueue(false, JMSQueueService.JMS_QUEUE_PREFIX + JMSQueueService.this.queueName, JMSQueueService.this.queueName, JMSQueueService.this.selectorString, JMSQueueService.this.durable, new String[0]);
                    JMSQueueService.this.queue = (Queue)ActiveMQDestination.createQueue((String)(JMSQueueService.JMS_QUEUE_PREFIX + JMSQueueService.this.queueName), (String)JMSQueueService.this.queueName);
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingLogger.ROOT_LOGGER.failedToCreate(e, "JMS Queue"));
                }
            }
        };
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public void stop(StopContext context) {
    }

    public Queue getValue() throws IllegalStateException, IllegalArgumentException {
        return this.queue;
    }

    public static Service<Queue> installService(String name, ServiceTarget serviceTarget, ServiceName serverServiceName, String selector, boolean durable) {
        JMSQueueService service = new JMSQueueService(name, selector, durable);
        ServiceName serviceName = JMSServices.getJmsQueueBaseServiceName(serverServiceName).append(new String[]{name});
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service);
        serviceBuilder.requires(ActiveMQActivationService.getServiceName(serverServiceName));
        serviceBuilder.addDependency(JMSServices.getJmsManagerBaseServiceName(serverServiceName), JMSServerManager.class, service.jmsServer);
        serviceBuilder.setInitialMode(ServiceController.Mode.PASSIVE);
        Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder, service.executorInjector);
        serviceBuilder.install();
        return service;
    }
}

