/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.logging.Logger;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CloseFuture
implements Closeable {
    private final Logger log;
    private final Promise<Void> promise = Promise.promise();
    private boolean closed;
    private Map<Closeable, CloseFuture> hooks;

    public CloseFuture() {
        this(null);
    }

    public CloseFuture(Logger log) {
        this.log = log;
    }

    public synchronized void add(Closeable hook) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (hook instanceof CloseFuture) {
            CloseFuture fut = (CloseFuture)hook;
            fut.future().onComplete(ar -> this.remove(fut));
        }
        if (this.hooks == null) {
            this.hooks = new WeakHashMap<Closeable, CloseFuture>();
        }
        this.hooks.put(hook, this);
    }

    public synchronized void remove(Closeable hook) {
        if (this.hooks != null) {
            this.hooks.remove(hook);
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public Future<Void> future() {
        return this.promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> close() {
        ArrayList<Closeable> toClose;
        boolean close;
        CloseFuture closeFuture = this;
        synchronized (closeFuture) {
            close = !this.closed;
            toClose = this.hooks != null ? new ArrayList<Closeable>(this.hooks.keySet()) : null;
            this.closed = true;
            this.hooks = null;
        }
        if (close) {
            if (toClose != null && !toClose.isEmpty()) {
                int num = toClose.size();
                AtomicInteger count = new AtomicInteger();
                for (Closeable hook : toClose) {
                    Promise<Void> closePromise = Promise.promise();
                    closePromise.future().onComplete(ar -> {
                        if (count.incrementAndGet() == num) {
                            this.promise.complete();
                        }
                    });
                    try {
                        hook.close(closePromise);
                    }
                    catch (Throwable t) {
                        if (this.log != null) {
                            this.log.warn("Failed to run close hook", t);
                        }
                        closePromise.tryFail(t);
                    }
                }
            } else {
                this.promise.complete();
            }
        }
        return this.promise.future();
    }

    @Override
    public void close(Promise<Void> completionHandler) {
        this.close().onComplete(completionHandler);
    }
}

