/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import org.apache.cxf.ws.rm.EncoderDecoder10Impl;
import org.apache.cxf.ws.rm.EncoderDecoder11Impl;
import org.apache.cxf.ws.rm.ProtocolVariation;

public class RMConfiguration {
    private Long inactivityTimeout;
    private Long acknowledgementInterval;
    private Long baseRetransmissionInterval;
    private boolean exponentialBackoff;
    private boolean sequenceSTRRequired;
    private boolean sequenceTransportSecurityRequired;
    private boolean inOrder;
    private DeliveryAssurance deliveryAssurance;
    private String rmNamespace;
    private String rm10AddressingNamespace;

    public RMConfiguration() {
    }

    public RMConfiguration(RMConfiguration base) {
        this.inactivityTimeout = base.inactivityTimeout;
        this.acknowledgementInterval = base.acknowledgementInterval;
        this.baseRetransmissionInterval = base.baseRetransmissionInterval;
        this.exponentialBackoff = base.exponentialBackoff;
        this.sequenceSTRRequired = base.sequenceSTRRequired;
        this.sequenceTransportSecurityRequired = base.sequenceTransportSecurityRequired;
        this.inOrder = base.inOrder;
        this.deliveryAssurance = base.deliveryAssurance;
        this.rmNamespace = base.rmNamespace;
        this.rm10AddressingNamespace = base.rm10AddressingNamespace;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public void setInOrder(boolean inOrder) {
        this.inOrder = inOrder;
    }

    public DeliveryAssurance getDeliveryAssurance() {
        return this.deliveryAssurance;
    }

    public void setDeliveryAssurance(DeliveryAssurance deliveryAssurance) {
        this.deliveryAssurance = deliveryAssurance;
    }

    public Long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public long getInactivityTimeoutTime() {
        return this.inactivityTimeout == null ? 0L : this.inactivityTimeout;
    }

    public void setInactivityTimeout(Long inactivityTimeout) {
        this.inactivityTimeout = inactivityTimeout;
    }

    public Long getAcknowledgementInterval() {
        return this.acknowledgementInterval;
    }

    public long getAcknowledgementIntervalTime() {
        return this.acknowledgementInterval == null ? 0L : this.acknowledgementInterval;
    }

    public void setAcknowledgementInterval(Long acknowledgementInterval) {
        this.acknowledgementInterval = acknowledgementInterval;
    }

    public Long getBaseRetransmissionInterval() {
        return this.baseRetransmissionInterval;
    }

    public void setBaseRetransmissionInterval(Long baseRetransmissionInterval) {
        this.baseRetransmissionInterval = baseRetransmissionInterval;
    }

    public boolean isExponentialBackoff() {
        return this.exponentialBackoff;
    }

    public void setExponentialBackoff(boolean exponentialBackoff) {
        this.exponentialBackoff = exponentialBackoff;
    }

    public boolean isSequenceSTRRequired() {
        return this.sequenceSTRRequired;
    }

    public void setSequenceSTRRequired(boolean sequenceSTRRequired) {
        this.sequenceSTRRequired = sequenceSTRRequired;
    }

    public boolean isSequenceTransportSecurityRequired() {
        return this.sequenceTransportSecurityRequired;
    }

    public void setSequenceTransportSecurityRequired(boolean sequenceTransportSecurityRequired) {
        this.sequenceTransportSecurityRequired = sequenceTransportSecurityRequired;
    }

    public String getRMNamespace() {
        return this.rmNamespace;
    }

    public void setRMNamespace(String uri) {
        this.rmNamespace = uri;
    }

    public String getRM10AddressingNamespace() {
        return this.rm10AddressingNamespace;
    }

    public void setRM10AddressingNamespace(String addrns) {
        this.rm10AddressingNamespace = addrns;
    }

    public String getAddressingNamespace() {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(this.rmNamespace)) {
            return this.rm10AddressingNamespace == null ? EncoderDecoder10Impl.INSTANCE.getWSANamespace() : this.rm10AddressingNamespace;
        }
        if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(this.rmNamespace)) {
            return EncoderDecoder11Impl.INSTANCE.getWSANamespace();
        }
        return "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    }

    public ProtocolVariation getProtocolVariation() {
        return ProtocolVariation.findVariant(this.getRMNamespace(), this.getRM10AddressingNamespace());
    }

    public static enum DeliveryAssurance {
        AT_MOST_ONCE,
        AT_LEAST_ONCE,
        EXACTLY_ONCE;

    }
}

