/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import io.opentelemetry.exporter.otlp.internal.MarshalerUtil;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import io.opentelemetry.proto.common.v1.internal.InstrumentationLibrary;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class InstrumentationLibraryMarshaler
extends MarshalerWithSize {
    private static final WeakConcurrentMap<InstrumentationLibraryInfo, InstrumentationLibraryMarshaler> LIBRARY_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction();
    private final byte[] serializedBinary;
    private final String serializedJson;

    public static InstrumentationLibraryMarshaler create(InstrumentationLibraryInfo libraryInfo) {
        InstrumentationLibraryMarshaler cached = (InstrumentationLibraryMarshaler)LIBRARY_MARSHALER_CACHE.get((Object)libraryInfo);
        if (cached == null) {
            byte[] name = MarshalerUtil.toBytes(libraryInfo.getName());
            byte[] version = MarshalerUtil.toBytes(libraryInfo.getVersion());
            RealInstrumentationLibraryMarshaler realMarshaler = new RealInstrumentationLibraryMarshaler(name, version);
            ByteArrayOutputStream binaryBos = new ByteArrayOutputStream(realMarshaler.getBinarySerializedSize());
            try {
                realMarshaler.writeBinaryTo(binaryBos);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", e);
            }
            String json = MarshalerUtil.preserializeJsonFields(realMarshaler);
            cached = new InstrumentationLibraryMarshaler(binaryBos.toByteArray(), json);
            LIBRARY_MARSHALER_CACHE.put((Object)libraryInfo, (Object)cached);
        }
        return cached;
    }

    private InstrumentationLibraryMarshaler(byte[] binary, String json) {
        super(binary.length);
        this.serializedBinary = binary;
        this.serializedJson = json;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeSerializedMessage(this.serializedBinary, this.serializedJson);
    }

    private static final class RealInstrumentationLibraryMarshaler
    extends MarshalerWithSize {
        private final byte[] name;
        private final byte[] version;

        RealInstrumentationLibraryMarshaler(byte[] name, byte[] version) {
            super(RealInstrumentationLibraryMarshaler.computeSize(name, version));
            this.name = name;
            this.version = version;
        }

        @Override
        protected void writeTo(Serializer output) throws IOException {
            output.serializeString(InstrumentationLibrary.NAME, this.name);
            output.serializeString(InstrumentationLibrary.VERSION, this.version);
        }

        private static int computeSize(byte[] name, byte[] version) {
            return MarshalerUtil.sizeBytes(InstrumentationLibrary.NAME, name) + MarshalerUtil.sizeBytes(InstrumentationLibrary.VERSION, version);
        }
    }
}

