/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.internal;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.validation.BootstrapConfiguration;
import jakarta.validation.ClockProvider;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cdi.internal.DestructibleBeanInstance;
import org.hibernate.validator.cdi.internal.InjectingConstraintValidatorFactory;
import org.hibernate.validator.cdi.internal.ValidationProviderHelper;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.classhierarchy.Filter;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.GetInstancesFromServiceLoader;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;
import org.hibernate.validator.metadata.BeanMetaDataClassNormalizer;

public class ValidatorFactoryBean
implements Bean<ValidatorFactory>,
PassivationCapable {
    private final BeanManager beanManager;
    private final Set<DestructibleBeanInstance<?>> destructibleResources;
    private final ValidationProviderHelper validationProviderHelper;
    private final Set<Type> types;

    public ValidatorFactoryBean(BeanManager beanManager, ValidationProviderHelper validationProviderHelper) {
        this.beanManager = beanManager;
        this.destructibleResources = CollectionHelper.newHashSet((int)5);
        this.validationProviderHelper = validationProviderHelper;
        this.types = Collections.unmodifiableSet(CollectionHelper.newHashSet((Collection)ClassHierarchyHelper.getHierarchy(validationProviderHelper.getValidatorFactoryBeanClass(), (Filter[])new Filter[0])));
    }

    public Class<?> getBeanClass() {
        return this.validationProviderHelper.getValidatorFactoryBeanClass();
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return null;
    }

    public Set<Annotation> getQualifiers() {
        return this.validationProviderHelper.getQualifiers();
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public ValidatorFactory create(CreationalContext<ValidatorFactory> ctx) {
        Configuration<?> config = this.getConfiguration();
        config.constraintValidatorFactory(this.createConstraintValidatorFactory(config));
        config.messageInterpolator(this.createMessageInterpolator(config));
        config.traversableResolver(this.createTraversableResolver(config));
        config.parameterNameProvider(this.createParameterNameProvider(config));
        config.clockProvider(this.createClockProvider(config));
        if (config instanceof HibernateValidatorConfiguration) {
            HibernateValidatorConfiguration hvConfig = (HibernateValidatorConfiguration)config;
            Instance beanMetaDataClassNormalizerInstance = this.beanManager.createInstance().select(BeanMetaDataClassNormalizer.class, new Annotation[]{NamedLiteral.of((String)"hibernate-validator-bean-meta-data-class-normalizer")});
            if (beanMetaDataClassNormalizerInstance.isResolvable()) {
                BeanMetaDataClassNormalizer normalizer = (BeanMetaDataClassNormalizer)beanMetaDataClassNormalizerInstance.get();
                this.destructibleResources.add(new DestructibleBeanInstance<BeanMetaDataClassNormalizer>(this.beanManager, normalizer));
                hvConfig.beanMetaDataClassNormalizer(normalizer);
            }
        }
        this.addValueExtractorBeans(config);
        return config.buildValidatorFactory();
    }

    private void addValueExtractorBeans(Configuration<?> config) {
        Map valueExtractorDescriptors = this.createValidationXmlValueExtractors(config).stream().collect(Collectors.toMap(ValueExtractorDescriptor::getKey, Function.identity()));
        for (ValueExtractorDescriptor serviceLoaderValueExtractorDescriptor : this.createServiceLoaderValueExtractors()) {
            valueExtractorDescriptors.putIfAbsent(serviceLoaderValueExtractorDescriptor.getKey(), serviceLoaderValueExtractorDescriptor);
        }
        for (ValueExtractorDescriptor valueExtractorDescriptor : valueExtractorDescriptors.values()) {
            config.addValueExtractor(valueExtractorDescriptor.getValueExtractor());
        }
    }

    public void destroy(ValidatorFactory instance, CreationalContext<ValidatorFactory> ctx) {
        for (DestructibleBeanInstance<?> resource : this.destructibleResources) {
            resource.destroy();
        }
        instance.close();
    }

    private MessageInterpolator createMessageInterpolator(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String messageInterpolatorFqcn = bootstrapConfiguration.getMessageInterpolatorClassName();
        if (messageInterpolatorFqcn == null) {
            return config.getDefaultMessageInterpolator();
        }
        Class messageInterpolatorClass = (Class)this.run((PrivilegedAction)LoadClass.action((String)messageInterpolatorFqcn, null));
        return (MessageInterpolator)this.createInstance(messageInterpolatorClass);
    }

    private TraversableResolver createTraversableResolver(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String traversableResolverFqcn = bootstrapConfiguration.getTraversableResolverClassName();
        if (traversableResolverFqcn == null) {
            return config.getDefaultTraversableResolver();
        }
        Class traversableResolverClass = (Class)this.run((PrivilegedAction)LoadClass.action((String)traversableResolverFqcn, null));
        return (TraversableResolver)this.createInstance(traversableResolverClass);
    }

    private ParameterNameProvider createParameterNameProvider(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String parameterNameProviderFqcn = bootstrapConfiguration.getParameterNameProviderClassName();
        if (parameterNameProviderFqcn == null) {
            return config.getDefaultParameterNameProvider();
        }
        Class parameterNameProviderClass = (Class)this.run((PrivilegedAction)LoadClass.action((String)parameterNameProviderFqcn, null));
        return (ParameterNameProvider)this.createInstance(parameterNameProviderClass);
    }

    private ClockProvider createClockProvider(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String clockProviderFqcn = bootstrapConfiguration.getClockProviderClassName();
        if (clockProviderFqcn == null) {
            return config.getDefaultClockProvider();
        }
        Class clockProviderClass = (Class)this.run((PrivilegedAction)LoadClass.action((String)clockProviderFqcn, null));
        return (ClockProvider)this.createInstance(clockProviderClass);
    }

    private ConstraintValidatorFactory createConstraintValidatorFactory(Configuration<?> config) {
        BootstrapConfiguration configSource = config.getBootstrapConfiguration();
        String constraintValidatorFactoryFqcn = configSource.getConstraintValidatorFactoryClassName();
        if (constraintValidatorFactoryFqcn == null) {
            return this.createInstance(InjectingConstraintValidatorFactory.class);
        }
        Class constraintValidatorFactoryClass = (Class)this.run((PrivilegedAction)LoadClass.action((String)constraintValidatorFactoryFqcn, null));
        return (ConstraintValidatorFactory)this.createInstance(constraintValidatorFactoryClass);
    }

    private Set<ValueExtractorDescriptor> createValidationXmlValueExtractors(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        Set valueExtractorFqcns = bootstrapConfiguration.getValueExtractorClassNames();
        Set<ValueExtractorDescriptor> valueExtractorDescriptors = valueExtractorFqcns.stream().map(fqcn -> (ValueExtractor)this.createInstance((Class)this.run((PrivilegedAction)LoadClass.action((String)fqcn, null)))).map(ve -> new ValueExtractorDescriptor(ve)).collect(Collectors.toSet());
        return valueExtractorDescriptors;
    }

    private Set<ValueExtractorDescriptor> createServiceLoaderValueExtractors() {
        HashSet<ValueExtractorDescriptor> valueExtractorDescriptors = new HashSet<ValueExtractorDescriptor>();
        List valueExtractors = (List)this.run((PrivilegedAction)GetInstancesFromServiceLoader.action((ClassLoader)((ClassLoader)this.run((PrivilegedAction)GetClassLoader.fromContext())), ValueExtractor.class));
        for (ValueExtractor valueExtractor : valueExtractors) {
            valueExtractorDescriptors.add(new ValueExtractorDescriptor(this.injectInstance(valueExtractor)));
        }
        return valueExtractorDescriptors;
    }

    private <T> T createInstance(Class<T> type) {
        DestructibleBeanInstance<Class<T>> destructibleInstance = new DestructibleBeanInstance<Class<T>>(this.beanManager, type);
        this.destructibleResources.add(destructibleInstance);
        return (T)destructibleInstance.getInstance();
    }

    private <T> T injectInstance(T instance) {
        DestructibleBeanInstance<T> destructibleInstance = new DestructibleBeanInstance<T>(this.beanManager, instance);
        this.destructibleResources.add(destructibleInstance);
        return destructibleInstance.getInstance();
    }

    private Configuration<?> getConfiguration() {
        return this.validationProviderHelper.isDefaultProvider() ? Validation.byDefaultProvider().configure() : Validation.byProvider(HibernateValidator.class).configure();
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    public String getId() {
        return ValidatorFactoryBean.class.getName() + "_" + (this.validationProviderHelper.isDefaultProvider() ? "default" : "hv");
    }

    public String toString() {
        return "ValidatorFactoryBean [id=" + this.getId() + "]";
    }
}

