/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.deployment;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class TransactionRollbackSetupAction
implements SetupAction,
Service<TransactionRollbackSetupAction> {
    private static final ThreadLocal<Holder> depth = new ThreadLocal();
    private final InjectedValue<TransactionManager> transactionManager = new InjectedValue();
    private final ServiceName serviceName;

    public TransactionRollbackSetupAction(ServiceName serviceName) {
        this.serviceName = serviceName;
    }

    public void setup(Map<String, Object> properties) {
        this.changeDepth(1);
    }

    public void teardown(Map<String, Object> properties) {
        TransactionManager tm;
        if (this.changeDepth(-1)) {
            this.checkTransactionStatus();
        }
        if ((tm = (TransactionManager)this.transactionManager.getOptionalValue()) != null) {
            try {
                tm.setTransactionTimeout(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int priority() {
        return 0;
    }

    public Set<ServiceName> dependencies() {
        return Collections.singleton(this.serviceName);
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public TransactionRollbackSetupAction getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<TransactionManager> getTransactionManager() {
        return this.transactionManager;
    }

    private boolean changeDepth(int increment) {
        Holder holder = depth.get();
        if (holder == null) {
            holder = new Holder();
            try {
                TransactionManager tm = (TransactionManager)this.transactionManager.getOptionalValue();
                if (tm != null) {
                    holder.actuallyCleanUp = !this.isTransactionActive(tm, tm.getStatus());
                }
                depth.set(holder);
            }
            catch (Exception e) {
                TransactionLogger.ROOT_LOGGER.unableToGetTransactionStatus(e);
            }
        }
        holder.depth += increment;
        if (holder.depth == 0) {
            depth.set(null);
            return holder.actuallyCleanUp;
        }
        return false;
    }

    private void checkTransactionStatus() {
        try {
            TransactionManager tm = (TransactionManager)this.transactionManager.getOptionalValue();
            if (tm == null) {
                return;
            }
            int status = tm.getStatus();
            boolean active = this.isTransactionActive(tm, status);
            if (active) {
                try {
                    TransactionLogger.ROOT_LOGGER.transactionStillOpen(status);
                    tm.rollback();
                }
                catch (Exception ex) {
                    TransactionLogger.ROOT_LOGGER.unableToRollBack(ex);
                }
            }
        }
        catch (Exception e) {
            TransactionLogger.ROOT_LOGGER.unableToGetTransactionStatus(e);
        }
    }

    private boolean isTransactionActive(TransactionManager tm, int status) throws SystemException {
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    private static class Holder {
        int depth;
        boolean actuallyCleanUp = true;

        private Holder() {
        }
    }
}

