/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.SpliteratorMapper;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.stream.StreamMarshalling;

public class ValueCacheCollection<K, V>
extends AbstractCloseableIteratorCollection<V, K, V>
implements CacheCollection<V> {
    private final CacheSet<CacheEntry<K, V>> cacheSet;

    public ValueCacheCollection(Cache<K, V> cache, CacheSet<CacheEntry<K, V>> cacheSet) {
        super(cache);
        this.cacheSet = cacheSet;
    }

    @Override
    public CloseableIterator<V> iterator() {
        return new IteratorMapper((Iterator)this.cacheSet.iterator(), CacheEntry::getValue);
    }

    @Override
    public CloseableSpliterator<V> spliterator() {
        return new SpliteratorMapper((Spliterator)this.cacheSet.spliterator(), CacheEntry::getValue);
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        try (CloseableIterator<V> it = this.iterator();){
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.size() > 0) {
            HashSet set = new HashSet(c);
            try (CloseableIterator<V> it = this.iterator();){
                while (!set.isEmpty() && it.hasNext()) {
                    set.remove(it.next());
                }
            }
            return set.isEmpty();
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        try (CloseableIterator<V> it = this.iterator();){
            while (it.hasNext()) {
                Object next = it.next();
                if (!o.equals(next)) continue;
                it.remove();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public CacheStream<V> stream() {
        Stream stream = this.cacheSet.stream();
        return (CacheStream)stream.map(StreamMarshalling.entryToValueFunction());
    }

    @Override
    public CacheStream<V> parallelStream() {
        Stream stream = this.cacheSet.parallelStream();
        return (CacheStream)stream.map(StreamMarshalling.entryToValueFunction());
    }
}

