/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerImpl;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ConsumerWindowSizeTest
extends ActiveMQTestBase {
    private final SimpleString addressA = new SimpleString("addressA");
    private final SimpleString queueA = new SimpleString("queueA");
    private final int TIMEOUT = 5;
    private ServerLocator locator;

    protected boolean isNetty() {
        return false;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createFactory(this.isNetty());
    }

    private int getMessageEncodeSize(SimpleString address) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession session = cf.createSession(false, true, true);
        ClientMessage message = session.createMessage(false);
        message.setAddress(address);
        int encodeSize = message.getEncodeSize();
        session.close();
        cf.close();
        return encodeSize;
    }

    @Test
    public void testReceiveImmediateWithZeroWindow() throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        server.start();
        this.locator.setConsumerWindowSize(0);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration("testWindow"));
        session.close();
        int numConsumers = 5;
        ArrayList<ClientConsumer> consumers = new ArrayList<ClientConsumer>();
        ArrayList<ClientSession> sessions = new ArrayList<ClientSession>();
        for (int i = 0; i < numConsumers; ++i) {
            ClientSession session1 = sf.createSession();
            ClientConsumer consumer = session1.createConsumer("testWindow");
            consumers.add(consumer);
            session1.start();
            sessions.add(session1);
            consumer.receiveImmediate();
        }
        ClientSession senderSession = sf.createSession(false, false);
        ClientProducer producer = senderSession.createProducer("testWindow");
        ClientMessage sent = senderSession.createMessage(true);
        sent.putStringProperty("hello", "world");
        producer.send((Message)sent);
        senderSession.commit();
        senderSession.start();
        ClientConsumer consumer = (ClientConsumer)consumers.get(2);
        ClientMessage received = consumer.receive(1000L);
        Assert.assertNotNull((Object)received);
        for (ClientSession tmpSess : sessions) {
            tmpSess.close();
        }
        senderSession.close();
    }

    @Test
    public void testReceiveImmediateWithZeroWindow2() throws Exception {
        ActiveMQServer server = this.createServer(true);
        try (ServerLocator locator = this.createInVMNonHALocator();){
            server.start();
            locator.setConsumerWindowSize(0);
            ClientSessionFactory sf = this.createSessionFactory(locator);
            ClientSession session = sf.createSession(false, false, false);
            session.createQueue(new QueueConfiguration("testReceive"));
            session.close();
            ClientSession sessionProd = sf.createSession(false, false);
            ClientMessage msg = sessionProd.createMessage(true);
            msg.putStringProperty("hello", "world");
            ClientProducer prod = sessionProd.createProducer("testReceive");
            prod.send((Message)msg);
            sessionProd.commit();
            ClientSession session1 = sf.createSession();
            ClientConsumer consumer = session1.createConsumer("testReceive");
            session1.start();
            Thread.sleep(1000L);
            ClientMessage message = null;
            message = consumer.receiveImmediate();
            Assert.assertNotNull((Object)message);
            message.acknowledge();
            prod.send((Message)msg);
            sessionProd.commit();
            message = consumer.receive(10000L);
            Assert.assertNotNull((Object)message);
            message.acknowledge();
            session.close();
            session1.close();
            sessionProd.close();
        }
    }

    @Test
    public void testReceiveImmediateWithZeroWindow3() throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        server.start();
        this.locator.setConsumerWindowSize(0);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration("testWindow"));
        session.close();
        int numConsumers = 5;
        ArrayList<ClientConsumer> consumers = new ArrayList<ClientConsumer>();
        ArrayList<ClientSession> sessions = new ArrayList<ClientSession>();
        for (int i = 0; i < numConsumers; ++i) {
            ClientSession session1 = sf.createSession();
            ClientConsumer consumer = session1.createConsumer("testWindow");
            consumers.add(consumer);
            session1.start();
            sessions.add(session1);
            consumer.receive(10L);
        }
        ClientSession senderSession = sf.createSession(false, false);
        ClientProducer producer = senderSession.createProducer("testWindow");
        ClientMessage sent = senderSession.createMessage(true);
        sent.putStringProperty("hello", "world");
        producer.send((Message)sent);
        senderSession.commit();
        senderSession.start();
        ClientConsumer consumer = (ClientConsumer)consumers.get(2);
        ClientMessage received = consumer.receive(1000L);
        Assert.assertNotNull((Object)received);
        for (ClientSession tmpSess : sessions) {
            tmpSess.close();
        }
        senderSession.close();
    }

    @Test
    public void testReceiveImmediateWithZeroWindow4() throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        server.start();
        this.locator.setConsumerWindowSize(0);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration("testWindow"));
        session.close();
        int numConsumers = 5;
        ArrayList<ClientConsumer> consumers = new ArrayList<ClientConsumer>();
        ArrayList<ClientSession> sessions = new ArrayList<ClientSession>();
        for (int i = 0; i < numConsumers; ++i) {
            ClientSession session1 = sf.createSession();
            ClientConsumer consumer = session1.createConsumer("testWindow");
            consumers.add(consumer);
            session1.start();
            sessions.add(session1);
            Assert.assertNull((Object)consumer.receive(10L));
        }
        ClientSession senderSession = sf.createSession(false, false);
        ClientProducer producer = senderSession.createProducer("testWindow");
        ClientMessage sent = senderSession.createMessage(true);
        sent.putStringProperty("hello", "world");
        producer.send((Message)sent);
        senderSession.commit();
        senderSession.start();
        ClientConsumer consumer = (ClientConsumer)consumers.get(2);
        ClientMessage received = consumer.receive(5000L);
        Assert.assertNotNull((Object)received);
        for (ClientSession tmpSess : sessions) {
            tmpSess.close();
        }
        senderSession.close();
    }

    @Test
    public void testMultipleImmediate() throws Exception {
        int NUMBER_OF_MESSAGES = 200;
        ActiveMQServer server = this.createServer(false, this.isNetty());
        server.start();
        this.locator.setConsumerWindowSize(0);
        final ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration("testWindow"));
        session.close();
        Thread[] threads = new Thread[10];
        final AtomicInteger errors = new AtomicInteger(0);
        final CountDownLatch latchStart = new CountDownLatch(1);
        final AtomicInteger received = new AtomicInteger(0);
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        ClientSession session = sf.createSession(false, false);
                        ClientConsumer consumer = session.createConsumer("testWindow");
                        session.start();
                        latchStart.await(10L, TimeUnit.SECONDS);
                        while (true) {
                            if (received.incrementAndGet() > 200) {
                                received.decrementAndGet();
                                break;
                            }
                            ClientMessage msg = consumer.receive(1000L);
                            msg.acknowledge();
                            session.commit();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                }
            };
            threads[i].start();
        }
        ClientSession senderSession = sf.createSession(false, false);
        ClientProducer producer = senderSession.createProducer("testWindow");
        ClientMessage sent = senderSession.createMessage(true);
        sent.putStringProperty("hello", "world");
        for (int i = 0; i < 200; ++i) {
            producer.send((Message)sent);
            senderSession.commit();
        }
        latchStart.countDown();
        for (Thread t : threads) {
            t.join();
        }
        Assert.assertEquals((long)0L, (long)errors.get());
        Assert.assertEquals((long)200L, (long)received.get());
    }

    @Test
    public void testSingleImmediate() throws Exception {
        int NUMBER_OF_MESSAGES = 200;
        ActiveMQServer server = this.createServer(false, this.isNetty());
        server.start();
        this.locator.setConsumerWindowSize(0);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false, false);
        session.createQueue(new QueueConfiguration("testWindow"));
        session.close();
        AtomicInteger received = new AtomicInteger(0);
        ClientSession senderSession = sf.createSession(false, false);
        ClientProducer producer = senderSession.createProducer("testWindow");
        ClientMessage sent = senderSession.createMessage(true);
        sent.putStringProperty("hello", "world");
        for (int i = 0; i < 200; ++i) {
            producer.send((Message)sent);
        }
        senderSession.commit();
        ClientSession session2 = sf.createSession(false, false);
        ClientConsumer consumer = session2.createConsumer("testWindow");
        session2.start();
        while (true) {
            ClientMessage msg;
            if ((msg = consumer.receiveImmediate()) == null) break;
            msg.acknowledge();
            session2.commit();
            received.incrementAndGet();
        }
        this.instanceLog.debug((Object)"Returning null");
        Assert.assertEquals((long)200L, (long)received.get());
    }

    @Test
    public void testSendWindowSize() throws Exception {
        ClientMessage m;
        int i;
        ActiveMQServer messagingService = this.createServer(false, this.isNetty());
        this.locator.setBlockOnNonDurableSend(false);
        messagingService.start();
        int numMessage = 100;
        this.locator.setConsumerWindowSize(numMessage * this.getMessageEncodeSize(this.addressA));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientSession receiveSession = cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientConsumer receivingConsumer = receiveSession.createConsumer(this.queueA);
        ClientSession session = cf.createSession(false, true, true);
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientConsumer cc = session.createConsumer(this.queueA);
        session.start();
        receiveSession.start();
        for (i = 0; i < numMessage * 4; ++i) {
            cp.send((Message)sendSession.createMessage(false));
        }
        for (i = 0; i < numMessage * 2; ++i) {
            m = receivingConsumer.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
        }
        receiveSession.close();
        for (i = 0; i < numMessage * 2; ++i) {
            m = cc.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
        }
        session.close();
        sendSession.close();
        Assert.assertEquals((long)0L, (long)this.getMessageCount(messagingService, this.queueA.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlowConsumerBufferingOne() throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        ClientSession sessionB = null;
        ClientSession session = null;
        try {
            int i;
            int numberOfMessages = 100;
            server.start();
            this.locator.setConsumerWindowSize(1);
            ClientSessionFactory sf = this.createSessionFactory(this.locator);
            session = sf.createSession(false, true, true);
            SimpleString ADDRESS = this.addressA;
            session.createQueue(new QueueConfiguration(ADDRESS));
            sessionB = sf.createSession(false, true, true);
            sessionB.start();
            session.start();
            ClientConsumer consNeverUsed = sessionB.createConsumer(ADDRESS);
            ClientConsumer cons1 = session.createConsumer(ADDRESS);
            ClientProducer prod = session.createProducer(ADDRESS);
            for (i = 0; i < 100; ++i) {
                prod.send((Message)this.createTextMessage(session, "Msg" + i));
            }
            for (i = 0; i < 99; ++i) {
                ClientMessage msg = cons1.receive(1000L);
                Assert.assertNotNull((String)("expected message at i = " + i), (Object)msg);
                msg.acknowledge();
            }
            ClientMessage msg = consNeverUsed.receive(500L);
            Assert.assertNotNull((Object)msg);
            msg.acknowledge();
            session.close();
            session = null;
            sessionB.close();
            sessionB = null;
            Assert.assertEquals((long)0L, (long)this.getMessageCount(server, ADDRESS.toString()));
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
                if (sessionB != null) {
                    sessionB.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testSlowConsumerNoBuffer() throws Exception {
        this.internalTestSlowConsumerNoBuffer(false);
    }

    @Test
    @Ignore(value="I believe this test became invalid after we started using another thread to deliver the large message")
    public void testSlowConsumerNoBufferLargeMessages() throws Exception {
        this.internalTestSlowConsumerNoBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTestSlowConsumerNoBuffer(boolean largeMessages) throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        ClientSession sessionB = null;
        ClientSession session = null;
        try {
            int i;
            int numberOfMessages = 100;
            server.start();
            this.locator.setConsumerWindowSize(0);
            if (largeMessages) {
                this.locator.setMinLargeMessageSize(100);
            }
            ClientSessionFactory sf = this.createSessionFactory(this.locator);
            session = sf.createSession(false, true, true);
            SimpleString ADDRESS = this.addressA;
            session.createQueue(new QueueConfiguration(ADDRESS));
            sessionB = sf.createSession(false, true, true);
            sessionB.start();
            session.start();
            ClientConsumerInternal consNeverUsed = (ClientConsumerInternal)sessionB.createConsumer(ADDRESS);
            ClientProducer prod = session.createProducer(ADDRESS);
            Assert.assertNull((Object)consNeverUsed.receive(1L));
            ClientMessage msg = this.createTextMessage(session, "This one will expire");
            if (largeMessages) {
                msg.getBodyBuffer().writeBytes(new byte[600]);
            }
            msg.setExpiration(System.currentTimeMillis() + 100L);
            prod.send((Message)msg);
            msg = this.createTextMessage(session, "First-on-non-buffered");
            prod.send((Message)msg);
            Thread.sleep(110L);
            msg = consNeverUsed.receive(5000L);
            Assert.assertNotNull((Object)msg);
            Assert.assertEquals((Object)"First-on-non-buffered", (Object)this.getTextMessage(msg));
            msg.acknowledge();
            ClientConsumer cons1 = session.createConsumer(ADDRESS);
            for (i = 0; i < 100; ++i) {
                msg = this.createTextMessage(session, "Msg" + i);
                if (largeMessages) {
                    msg.getBodyBuffer().writeBytes(new byte[600]);
                }
                prod.send((Message)msg);
            }
            for (i = 0; i < 100; ++i) {
                msg = cons1.receive(1000L);
                Assert.assertNotNull((String)("expected message at i = " + i), (Object)msg);
                Assert.assertEquals((Object)("Msg" + i), (Object)this.getTextMessage(msg));
                msg.acknowledge();
            }
            Assert.assertEquals((long)0L, (long)consNeverUsed.getBufferSize());
            session.close();
            session = null;
            sessionB.close();
            sessionB = null;
            Assert.assertEquals((long)0L, (long)this.getMessageCount(server, ADDRESS.toString()));
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
                if (sessionB != null) {
                    sessionB.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testSlowConsumerNoBuffer2() throws Exception {
        this.internalTestSlowConsumerNoBuffer2(false);
    }

    @Test
    public void testSlowConsumerNoBuffer2LargeMessages() throws Exception {
        this.internalTestSlowConsumerNoBuffer2(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTestSlowConsumerNoBuffer2(boolean largeMessages) throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        ClientSession session1 = null;
        ClientSession session2 = null;
        try {
            String str;
            ClientMessage msg;
            int i;
            int numberOfMessages = 10;
            server.start();
            this.locator.setConsumerWindowSize(0);
            if (largeMessages) {
                this.locator.setMinLargeMessageSize(100);
            }
            ClientSessionFactory sf = this.createSessionFactory(this.locator);
            session1 = sf.createSession(false, true, true);
            session2 = sf.createSession(false, true, true);
            session1.start();
            session2.start();
            SimpleString ADDRESS = new SimpleString("some-queue");
            session1.createQueue(new QueueConfiguration(ADDRESS));
            ClientConsumerInternal cons1 = (ClientConsumerInternal)session1.createConsumer(ADDRESS);
            ClientProducer prod = session1.createProducer(ADDRESS);
            for (int i2 = 0; i2 < 10; ++i2) {
                ClientMessage msg2 = this.createTextMessage(session1, "Msg" + i2);
                if (largeMessages) {
                    msg2.getBodyBuffer().writeBytes(new byte[600]);
                }
                prod.send((Message)msg2);
            }
            ClientConsumerInternal cons2 = (ClientConsumerInternal)session2.createConsumer(ADDRESS);
            for (i = 0; i < 5; ++i) {
                msg = cons1.receive(1000L);
                Assert.assertNotNull((String)("expected message at i = " + i), (Object)msg);
                str = this.getTextMessage(msg);
                Assert.assertEquals((Object)("Msg" + i), (Object)str);
                msg.acknowledge();
                Assert.assertEquals((String)"A slow consumer shouldn't buffer anything on the client side!", (long)0L, (long)cons1.getBufferSize());
            }
            for (i = 5; i < 10; ++i) {
                msg = cons2.receive(1000L);
                Assert.assertNotNull((String)("expected message at i = " + i), (Object)msg);
                str = this.getTextMessage(msg);
                Assert.assertEquals((Object)("Msg" + i), (Object)str);
                msg.acknowledge();
                Assert.assertEquals((String)"A slow consumer shouldn't buffer anything on the client side!", (long)0L, (long)cons2.getBufferSize());
            }
            session1.close();
            session2.close();
            session1 = sf.createSession(false, true, true);
            session1.start();
            session2 = sf.createSession(false, true, true);
            session2.start();
            prod = session1.createProducer(ADDRESS);
            Assert.assertEquals((long)0L, (long)this.getMessageCount(server, ADDRESS.toString()));
            cons1.close();
            cons2.close();
            cons1 = (ClientConsumerInternal)session1.createConsumer(ADDRESS);
            for (i = 0; i < 10; ++i) {
                msg = this.createTextMessage(session1, "Msg" + i);
                if (largeMessages) {
                    msg.getBodyBuffer().writeBytes(new byte[600]);
                }
                prod.send((Message)msg);
            }
            cons2 = (ClientConsumerInternal)session2.createConsumer(ADDRESS);
            for (i = 0; i < 5; ++i) {
                msg = cons2.receive(1000L);
                Assert.assertNotNull((String)("expected message at i = " + i), (Object)msg);
                Assert.assertEquals((Object)("Msg" + i), (Object)msg.getBodyBuffer().readString());
                msg.acknowledge();
                Assert.assertEquals((String)"A slow consumer shouldn't buffer anything on the client side!", (long)0L, (long)cons2.getBufferSize());
            }
            for (i = 5; i < 10; ++i) {
                msg = cons1.receive(1000L);
                Assert.assertNotNull((String)("expected message at i = " + i), (Object)msg);
                Assert.assertEquals((Object)("Msg" + i), (Object)msg.getBodyBuffer().readString());
                msg.acknowledge();
                Assert.assertEquals((String)"A slow consumer shouldn't buffer anything on the client side!", (long)0L, (long)cons1.getBufferSize());
            }
            session1.close();
            session1 = null;
            session2.close();
            session2 = null;
            Assert.assertEquals((long)0L, (long)this.getMessageCount(server, ADDRESS.toString()));
        }
        finally {
            try {
                if (session1 != null) {
                    session1.close();
                }
                if (session2 != null) {
                    session2.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveBuffersOnLargeMessage() throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        ClientSession session1 = null;
        try {
            ClientMessage msg;
            int i;
            int numberOfMessages = 10;
            server.start();
            this.locator.setConsumerWindowSize(0).setMinLargeMessageSize(100);
            ClientSessionFactory sf = this.createSessionFactory(this.locator);
            session1 = sf.createSession(false, true, true);
            session1.start();
            SimpleString ADDRESS = new SimpleString("some-queue");
            session1.createQueue(new QueueConfiguration(ADDRESS));
            ClientConsumerInternal cons1 = (ClientConsumerInternal)session1.createConsumer(ADDRESS);
            ClientProducer prod = session1.createProducer(ADDRESS);
            for (i = 0; i < 10; ++i) {
                msg = session1.createMessage(true);
                msg.getBodyBuffer().writeBytes(new byte[600]);
                prod.send((Message)msg);
            }
            for (i = 0; i < 10; ++i) {
                msg = cons1.receive(1000L);
                Assert.assertNotNull((String)("expected message at i = " + i), (Object)msg);
                msg.saveToOutputStream((OutputStream)new FakeOutputStream());
                msg.acknowledge();
                Assert.assertEquals((String)"A slow consumer shouldn't buffer anything on the client side!", (long)0L, (long)cons1.getBufferSize());
            }
            session1.close();
            session1.close();
            session1 = null;
            Assert.assertEquals((long)0L, (long)this.getMessageCount(server, ADDRESS.toString()));
        }
        finally {
            try {
                if (session1 != null) {
                    session1.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testSlowConsumerOnMessageHandlerNoBuffers() throws Exception {
        this.internalTestSlowConsumerOnMessageHandlerNoBuffers(false);
    }

    @Test
    public void testSlowConsumerOnMessageHandlerNoBuffersLargeMessage() throws Exception {
        this.internalTestSlowConsumerOnMessageHandlerNoBuffers(true);
    }

    @Test
    public void testFlowControl() throws Exception {
        this.internalTestFlowControlOnRollback(false);
    }

    @Test
    public void testFlowControlLargeMessage() throws Exception {
        this.internalTestFlowControlOnRollback(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTestFlowControlOnRollback(boolean isLargeMessage) throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        AddressSettings settings = new AddressSettings().setMaxDeliveryAttempts(-1);
        server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        ClientSession session = null;
        try {
            int numberOfMessages = 100;
            server.start();
            this.locator.setConsumerWindowSize(300000);
            if (isLargeMessage) {
                this.locator.setMinLargeMessageSize(100);
            } else {
                this.locator.setMinLargeMessageSize(Integer.MAX_VALUE);
            }
            ClientSessionFactory sf = this.createSessionFactory(this.locator);
            session = sf.createSession(false, false, false);
            SimpleString ADDRESS = new SimpleString("some-queue");
            session.createQueue(new QueueConfiguration(ADDRESS));
            ClientProducer producer = session.createProducer(ADDRESS);
            for (int i = 0; i < 100; ++i) {
                ClientMessage msg = session.createMessage(true);
                msg.putIntProperty("count", i);
                msg.getBodyBuffer().writeBytes(new byte[1024]);
                producer.send((Message)msg);
            }
            session.commit();
            ClientConsumerInternal consumer = (ClientConsumerInternal)session.createConsumer(ADDRESS);
            session.start();
            for (int repeat = 0; repeat < 100; ++repeat) {
                long timeout = System.currentTimeMillis() + 2000L;
                while (timeout > System.currentTimeMillis() && consumer.getBufferSize() <= 10) {
                    Thread.sleep(10L);
                }
                Assert.assertTrue((consumer.getBufferSize() >= 10 ? (byte)1 : 0) != 0);
                ClientMessage msg = consumer.receive(500L);
                msg.getBodyBuffer().readByte();
                Assert.assertNotNull((Object)msg);
                msg.acknowledge();
                session.rollback();
            }
            for (int i = 0; i < 100; ++i) {
                ClientMessage msg = consumer.receive(5000L);
                Assert.assertNotNull((Object)msg);
                msg.getBodyBuffer().readByte();
                msg.acknowledge();
                session.commit();
            }
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTestSlowConsumerOnMessageHandlerNoBuffers(final boolean largeMessages) throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        ClientSession sessionB = null;
        ClientSession session = null;
        try {
            ClientMessage msg;
            int i;
            int numberOfMessages = 100;
            server.start();
            this.locator.setConsumerWindowSize(0);
            if (largeMessages) {
                this.locator.setMinLargeMessageSize(100);
            }
            ClientSessionFactory sf = this.createSessionFactory(this.locator);
            session = sf.createSession(false, true, true);
            SimpleString ADDRESS = new SimpleString("some-queue");
            session.createQueue(new QueueConfiguration(ADDRESS));
            sessionB = sf.createSession(false, true, true);
            sessionB.start();
            session.start();
            ClientConsumerInternal consReceiveOneAndHold = (ClientConsumerInternal)sessionB.createConsumer(ADDRESS);
            final CountDownLatch latchReceived = new CountDownLatch(2);
            final CountDownLatch latchDone = new CountDownLatch(1);
            final CountDownLatch latchRead = new CountDownLatch(1);
            class LocalHandler
            implements MessageHandler {
                boolean failed = false;
                int count = 0;

                LocalHandler() {
                }

                public synchronized void onMessage(ClientMessage message) {
                    try {
                        String str = ConsumerWindowSizeTest.this.getTextMessage(message);
                        this.failed = this.failed || !str.equals("Msg" + this.count);
                        message.acknowledge();
                        latchReceived.countDown();
                        if (this.count++ == 1) {
                            if (!latchDone.await(5L, TimeUnit.SECONDS)) {
                                new Exception("ClientConsuemrWindowSizeTest Handler couldn't receive signal in less than 5 seconds").printStackTrace();
                                this.failed = true;
                            }
                            if (largeMessages) {
                                message.getBodyBuffer().readBytes(new byte[600]);
                            }
                            latchRead.countDown();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.failed = true;
                    }
                }
            }
            LocalHandler handler = new LocalHandler();
            ClientConsumer cons1 = session.createConsumer(ADDRESS);
            ClientProducer prod = session.createProducer(ADDRESS);
            for (i = 0; i < 100; ++i) {
                msg = this.createTextMessage(session, "Msg" + i);
                if (largeMessages) {
                    msg.getBodyBuffer().writeBytes(new byte[600]);
                }
                prod.send((Message)msg);
            }
            consReceiveOneAndHold.setMessageHandler((MessageHandler)handler);
            Assert.assertTrue((boolean)latchReceived.await(5L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)consReceiveOneAndHold.getBufferSize());
            for (i = 2; i < 100; ++i) {
                msg = cons1.receive(1000L);
                Assert.assertNotNull((String)("expected message at i = " + i), (Object)msg);
                Assert.assertEquals((Object)("Msg" + i), (Object)this.getTextMessage(msg));
                msg.acknowledge();
            }
            Assert.assertEquals((long)0L, (long)consReceiveOneAndHold.getBufferSize());
            latchDone.countDown();
            Assert.assertTrue((boolean)latchRead.await(10L, TimeUnit.SECONDS));
            session.close();
            session = null;
            sessionB.close();
            sessionB = null;
            Assert.assertEquals((long)0L, (long)this.getMessageCount(server, ADDRESS.toString()));
            Assert.assertFalse((String)"MessageHandler received a failure", (boolean)handler.failed);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
                if (sessionB != null) {
                    sessionB.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testSlowConsumerOnMessageHandlerBufferOne() throws Exception {
        this.internalTestSlowConsumerOnMessageHandlerBufferOne(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTestSlowConsumerOnMessageHandlerBufferOne(boolean largeMessage) throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        ClientSession sessionB = null;
        ClientSession session = null;
        try {
            int numberOfMessages = 100;
            server.start();
            this.locator.setConsumerWindowSize(1);
            if (largeMessage) {
                this.locator.setMinLargeMessageSize(100);
            }
            ClientSessionFactory sf = this.createSessionFactory(this.locator);
            session = sf.createSession(false, true, true);
            SimpleString ADDRESS = new SimpleString("some-queue");
            session.createQueue(new QueueConfiguration(ADDRESS));
            sessionB = sf.createSession(false, true, true);
            sessionB.start();
            session.start();
            ClientConsumerInternal consReceiveOneAndHold = (ClientConsumerInternal)sessionB.createConsumer(ADDRESS);
            final CountDownLatch latchReceived = new CountDownLatch(2);
            final CountDownLatch latchReceivedBuffered = new CountDownLatch(3);
            final CountDownLatch latchDone = new CountDownLatch(1);
            class LocalHandler
            implements MessageHandler {
                boolean failed = false;
                int count = 0;

                LocalHandler() {
                }

                public synchronized void onMessage(ClientMessage message) {
                    try {
                        String str = ConsumerWindowSizeTest.this.getTextMessage(message);
                        this.failed = this.failed || !str.equals("Msg" + this.count);
                        message.acknowledge();
                        latchReceived.countDown();
                        latchReceivedBuffered.countDown();
                        if (this.count++ == 1 && !latchDone.await(5L, TimeUnit.SECONDS)) {
                            new Exception("ClientConsuemrWindowSizeTest Handler couldn't receive signal in less than 5 seconds").printStackTrace();
                            this.failed = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.failed = true;
                    }
                }
            }
            LocalHandler handler = new LocalHandler();
            ClientProducer prod = session.createProducer(ADDRESS);
            for (int i = 0; i < 100; ++i) {
                ClientMessage msg = this.createTextMessage(session, "Msg" + i);
                if (largeMessage) {
                    msg.getBodyBuffer().writeBytes(new byte[600]);
                }
                prod.send((Message)msg);
            }
            consReceiveOneAndHold.setMessageHandler((MessageHandler)handler);
            Assert.assertTrue((boolean)latchReceived.await(5L, TimeUnit.SECONDS));
            long timeout = System.currentTimeMillis() + 5000L;
            while (consReceiveOneAndHold.getBufferSize() == 0 && System.currentTimeMillis() < timeout) {
                Thread.sleep(10L);
            }
            Assert.assertEquals((long)1L, (long)consReceiveOneAndHold.getBufferSize());
            ClientConsumer cons1 = session.createConsumer(ADDRESS);
            for (int i = 3; i < 100; ++i) {
                ClientMessage msg = cons1.receive(1000L);
                Assert.assertNotNull((String)("expected message at i = " + i), (Object)msg);
                String text = this.getTextMessage(msg);
                Assert.assertEquals((Object)("Msg" + i), (Object)text);
                msg.acknowledge();
            }
            latchDone.countDown();
            Assert.assertTrue((boolean)latchReceivedBuffered.await(5L, TimeUnit.SECONDS));
            session.close();
            session = null;
            sessionB.close();
            sessionB = null;
            Assert.assertEquals((long)0L, (long)this.getMessageCount(server, ADDRESS.toString()));
            Assert.assertFalse((String)"MessageHandler received a failure", (boolean)handler.failed);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
                if (sessionB != null) {
                    sessionB.close();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    @Test
    public void testNoWindowRoundRobin() throws Exception {
        this.testNoWindowRoundRobin(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNoWindowRoundRobin(boolean largeMessages) throws Exception {
        ActiveMQServer server = this.createServer(false, this.isNetty());
        ClientSession sessionA = null;
        ClientSession sessionB = null;
        try {
            int numberOfMessages = 100;
            server.start();
            this.locator.setConsumerWindowSize(-1);
            if (largeMessages) {
                this.locator.setMinLargeMessageSize(100);
            }
            ClientSessionFactory sf = this.createSessionFactory(this.locator);
            sessionA = sf.createSession(false, true, true);
            SimpleString ADDRESS = new SimpleString("some-queue");
            sessionA.createQueue(new QueueConfiguration(ADDRESS));
            sessionB = sf.createSession(false, true, true);
            sessionA.start();
            sessionB.start();
            ClientConsumerInternal consA = (ClientConsumerInternal)sessionA.createConsumer(ADDRESS);
            ClientConsumerInternal consB = (ClientConsumerInternal)sessionB.createConsumer(ADDRESS);
            Bindings bindings = server.getPostOffice().getBindingsForAddress(ADDRESS);
            Assert.assertEquals((long)1L, (long)bindings.getBindings().size());
            for (Binding binding : bindings.getBindings()) {
                Collection consumers = ((QueueBinding)binding).getQueue().getConsumers();
                for (Consumer consumer : consumers) {
                    ServerConsumerImpl consumerImpl = (ServerConsumerImpl)consumer;
                    long timeout = System.currentTimeMillis() + 5000L;
                    while (timeout > System.currentTimeMillis() && consumerImpl.getAvailableCredits() != null) {
                        Thread.sleep(10L);
                    }
                    Assert.assertNull((Object)consumerImpl.getAvailableCredits());
                }
            }
            ClientProducer prod = sessionA.createProducer(ADDRESS);
            for (int i = 0; i < 100; ++i) {
                ClientMessage msg = this.createTextMessage(sessionA, "Msg" + i);
                if (largeMessages) {
                    msg.getBodyBuffer().writeBytes(new byte[600]);
                }
                prod.send((Message)msg);
            }
            long timeout = System.currentTimeMillis() + 5000L;
            boolean foundA = false;
            boolean foundB = false;
            do {
                foundA = consA.getBufferSize() == 50;
                foundB = consB.getBufferSize() == 50;
                Thread.sleep(10L);
            } while ((!foundA || !foundB) && System.currentTimeMillis() < timeout);
            Assert.assertTrue((String)("ConsumerA didn't receive the expected number of messages on buffer (consA=" + consA.getBufferSize() + ", consB=" + consB.getBufferSize() + ") foundA = " + foundA + " foundB = " + foundB), (boolean)foundA);
            Assert.assertTrue((String)("ConsumerB didn't receive the expected number of messages on buffer (consA=" + consA.getBufferSize() + ", consB=" + consB.getBufferSize() + ") foundA = " + foundA + " foundB = " + foundB), (boolean)foundB);
        }
        finally {
            try {
                if (sessionA != null) {
                    sessionA.close();
                }
                if (sessionB != null) {
                    sessionB.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testDefaultConsumerWindowSize() throws Exception {
        ActiveMQServer messagingService = this.createServer(false, this.isNetty());
        messagingService.start();
        messagingService.createQueue(new QueueConfiguration(this.queueA).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession(false, true, true);
        ClientConsumerImpl consumer = (ClientConsumerImpl)session.createConsumer(this.queueA);
        consumer.start();
        ConsumerWindowSizeTest.assertEquals((long)524288L, (long)consumer.getClientWindowSize());
    }

    @Test
    public void testConsumerWindowSizeAddressSettings() throws Exception {
        ActiveMQServer messagingService = this.createServer(false, this.isNetty());
        int defaultConsumerWindowSize = 5120;
        AddressSettings settings = new AddressSettings();
        settings.setDefaultConsumerWindowSize(5120);
        messagingService.getConfiguration().getAddressesSettings().put(this.queueA.toString(), settings);
        messagingService.start();
        messagingService.createQueue(new QueueConfiguration(this.queueA).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession(false, true, true);
        ClientConsumerImpl consumer = (ClientConsumerImpl)session.createConsumer(this.queueA);
        session.start();
        ConsumerWindowSizeTest.assertEquals((long)2560L, (long)consumer.getClientWindowSize());
    }

    @Test
    public void testConsumerWindowSizeAddressSettingsDifferentAddressAndQueueName() throws Exception {
        ActiveMQServer messagingService = this.createServer(false, this.isNetty());
        int defaultConsumerWindowSize = 5120;
        AddressSettings settings = new AddressSettings();
        settings.setDefaultConsumerWindowSize(5120);
        messagingService.getConfiguration().getAddressesSettings().put(this.addressA.toString(), settings);
        messagingService.start();
        messagingService.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession(false, true, true);
        ClientConsumerImpl consumer = (ClientConsumerImpl)session.createConsumer(this.queueA);
        session.start();
        ConsumerWindowSizeTest.assertEquals((long)2560L, (long)consumer.getClientWindowSize());
        ServerSession ss = messagingService.getSessionByID(((ClientSessionImpl)session).getName());
        ServerConsumerImpl cons = (ServerConsumerImpl)ss.locateConsumer(consumer.getConsumerContext().getId());
        ConsumerWindowSizeTest.assertTrue((boolean)Wait.waitFor(() -> cons.getAvailableCredits().get() == consumer.getClientWindowSize() * 2, (long)5000L, (long)50L));
    }

    @Test
    public void testConsumerWindowSizeAddressSettingsWildCard() throws Exception {
        ActiveMQServer messagingService = this.createServer(false, this.isNetty());
        int defaultConsumerWindowSize = 5120;
        AddressSettings settings = new AddressSettings();
        settings.setDefaultConsumerWindowSize(5120);
        messagingService.getConfiguration().getAddressesSettings().put("#", settings);
        messagingService.start();
        messagingService.createQueue(new QueueConfiguration(this.queueA).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession(false, true, true);
        ClientConsumerImpl consumer = (ClientConsumerImpl)session.createConsumer(this.queueA);
        ClientConsumerImpl consumer2 = (ClientConsumerImpl)session.createConsumer(this.queueA);
        session.start();
        ConsumerWindowSizeTest.assertEquals((long)2560L, (long)consumer.getClientWindowSize());
        ConsumerWindowSizeTest.assertEquals((long)2560L, (long)consumer2.getClientWindowSize());
    }

    class FakeOutputStream
    extends OutputStream {
        FakeOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

